/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.request;

import android.bluetooth.BluetoothGattCharacteristic;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.BleRequestImpl;
import cn.com.heaton.blelibrary.ble.annotation.Implement;
import cn.com.heaton.blelibrary.ble.callback.BleWriteCallback;
import cn.com.heaton.blelibrary.ble.callback.BleWriteEntityCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.BleWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.WriteWrapperCallback;
import cn.com.heaton.blelibrary.ble.exception.BleWriteException;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import cn.com.heaton.blelibrary.ble.model.EntityData;
import cn.com.heaton.blelibrary.ble.utils.ThreadUtils;
import java.math.BigDecimal;
import java.util.UUID;
import java.util.concurrent.Callable;

@Implement(value=WriteRequest.class)
public class WriteRequest<T extends BleDevice>
implements WriteWrapperCallback<T> {
    private BleWriteCallback<T> bleWriteCallback;
    private BleWriteEntityCallback<T> bleWriteEntityCallback;
    private boolean isWritingEntity;
    private boolean isAutoWriteMode = false;
    private final Object lock = new Object();
    private BleWrapperCallback<T> bleWrapperCallback;

    protected WriteRequest() {
        this.bleWrapperCallback = Ble.options().bleWrapperCallback;
    }

    public boolean write(T device, byte[] data, BleWriteCallback<T> callback) {
        this.bleWriteCallback = callback;
        BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        return bleRequest.wirteCharacteristic(((BleDevice)device).getBleAddress(), data);
    }

    public boolean writeByUuid(T device, byte[] data, UUID serviceUUID, UUID characteristicUUID, BleWriteCallback<T> callback) {
        this.bleWriteCallback = callback;
        BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        return bleRequest.wirteCharacteristicByUuid(((BleDevice)device).getBleAddress(), data, serviceUUID, characteristicUUID);
    }

    public void cancelWriteEntity() {
        if (this.isWritingEntity) {
            this.isWritingEntity = false;
            this.isAutoWriteMode = false;
        }
    }

    public void writeEntity(EntityData entityData, BleWriteEntityCallback<T> callback) {
        EntityData.validParms(entityData);
        this.bleWriteEntityCallback = callback;
        this.executeEntity(entityData);
    }

    public void writeEntity(T device, byte[] data, int packLength, int delay, BleWriteEntityCallback<T> callback) {
        this.bleWriteEntityCallback = callback;
        if (data == null || data.length == 0) {
            throw new BleWriteException("Send Entity cannot be empty");
        }
        if (packLength <= 0) {
            throw new BleWriteException("The data length per packet cannot be less than 0");
        }
        EntityData entityData = new EntityData(((BleDevice)device).getBleAddress(), data, packLength, delay);
        this.executeEntity(entityData);
    }

    private void executeEntity(EntityData entityData) {
        final boolean autoWriteMode = entityData.isAutoWriteMode();
        final byte[] data = entityData.getData();
        final int packLength = entityData.getPackLength();
        final String address = entityData.getAddress();
        final long delay = entityData.getDelay();
        final boolean lastPackComplete = entityData.isLastPackComplete();
        final BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                int length;
                WriteRequest.this.isWritingEntity = true;
                WriteRequest.this.isAutoWriteMode = autoWriteMode;
                int index = 0;
                int availableLength = length = data.length;
                while (index < length) {
                    if (!WriteRequest.this.isWritingEntity) {
                        if (WriteRequest.this.bleWriteEntityCallback != null) {
                            WriteRequest.this.bleWriteEntityCallback.onWriteCancel();
                            WriteRequest.this.isAutoWriteMode = false;
                        }
                        return false;
                    }
                    int onePackLength = packLength;
                    if (!lastPackComplete) {
                        onePackLength = availableLength >= packLength ? packLength : availableLength;
                    }
                    byte[] txBuffer = new byte[onePackLength];
                    for (int i = 0; i < onePackLength; ++i) {
                        if (index >= length) continue;
                        txBuffer[i] = data[index++];
                    }
                    availableLength -= onePackLength;
                    boolean result = bleRequest.wirteCharacteristic(address, txBuffer);
                    if (!result) {
                        if (WriteRequest.this.bleWriteEntityCallback != null) {
                            WriteRequest.this.bleWriteEntityCallback.onWriteFailed();
                            WriteRequest.this.isWritingEntity = false;
                            WriteRequest.this.isAutoWriteMode = false;
                            return false;
                        }
                    } else if (WriteRequest.this.bleWriteEntityCallback != null) {
                        double progress = new BigDecimal((float)index / (float)length).setScale(2, 4).doubleValue();
                        WriteRequest.this.bleWriteEntityCallback.onWriteProgress(progress);
                    }
                    if (autoWriteMode) {
                        Object progress = WriteRequest.this.lock;
                        synchronized (progress) {
                            WriteRequest.this.lock.wait(500L);
                            continue;
                        }
                    }
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (WriteRequest.this.bleWriteEntityCallback != null) {
                    WriteRequest.this.bleWriteEntityCallback.onWriteSuccess();
                    WriteRequest.this.isWritingEntity = false;
                    WriteRequest.this.isAutoWriteMode = false;
                }
                return true;
            }
        };
        ThreadUtils.submit(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWriteSuccess(T device, BluetoothGattCharacteristic characteristic) {
        if (this.bleWriteCallback != null) {
            this.bleWriteCallback.onWriteSuccess(device, characteristic);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onWriteSuccess(device, characteristic);
        }
        if (this.isAutoWriteMode) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }

    @Override
    public void onWriteFailed(T device, int failedCode) {
        if (this.bleWriteCallback != null) {
            this.bleWriteCallback.onWriteFailed(device, failedCode);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onWriteFailed(device, failedCode);
        }
    }
}

