/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.request;

import android.bluetooth.BluetoothGattCharacteristic;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.BleRequestImpl;
import cn.com.heaton.blelibrary.ble.annotation.Implement;
import cn.com.heaton.blelibrary.ble.callback.BleNotifyCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.BleWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.NotifyWrapperCallback;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import java.util.UUID;

@Implement(value=NotifyRequest.class)
public class NotifyRequest<T extends BleDevice>
implements NotifyWrapperCallback<T> {
    private static final String TAG = "NotifyRequest";
    private BleNotifyCallback<T> notiftCallback;
    private BleWrapperCallback<T> bleWrapperCallback;

    protected NotifyRequest() {
        this.bleWrapperCallback = Ble.options().bleWrapperCallback;
    }

    public void notify(T device, boolean enable, BleNotifyCallback<T> callback) {
        this.notiftCallback = callback;
        BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        bleRequest.setCharacteristicNotification(((BleDevice)device).getBleAddress(), enable);
    }

    public void notifyByUuid(T device, boolean enable, UUID serviceUUID, UUID characteristicUUID, BleNotifyCallback<T> callback) {
        this.notiftCallback = callback;
        BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        bleRequest.setCharacteristicNotificationByUuid(((BleDevice)device).getBleAddress(), enable, serviceUUID, characteristicUUID);
    }

    @Deprecated
    public void cancelNotify(T device, BleNotifyCallback<T> callback) {
        this.notiftCallback = callback;
        BleRequestImpl bleRequest = BleRequestImpl.getBleRequest();
        bleRequest.setCharacteristicNotification(((BleDevice)device).getBleAddress(), false);
    }

    @Override
    public void onChanged(T device, BluetoothGattCharacteristic characteristic) {
        if (null != this.notiftCallback) {
            this.notiftCallback.onChanged(device, characteristic);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onChanged(device, characteristic);
        }
    }

    @Override
    public void onNotifySuccess(T device) {
        if (null != this.notiftCallback) {
            this.notiftCallback.onNotifySuccess(device);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onNotifySuccess(device);
        }
    }

    @Override
    public void onNotifyCanceled(T device) {
        if (null != this.notiftCallback) {
            this.notiftCallback.onNotifyCanceled(device);
        }
        if (this.bleWrapperCallback != null) {
            this.bleWrapperCallback.onNotifyCanceled(device);
        }
    }
}

