/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.queue;

import cn.com.heaton.blelibrary.ble.queue.RequestTask;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class Task
implements Delayed {
    private static final String TAG = "Task";
    private final long timeOut;
    private final long realTime;
    private final RequestTask requestTask;
    private static final AtomicLong atomic = new AtomicLong(0L);
    private final long sequenceNum;

    public Task(long realTime, long timeout, RequestTask requestTask) {
        this.realTime = realTime;
        this.timeOut = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.MILLISECONDS);
        this.requestTask = requestTask;
        this.sequenceNum = atomic.getAndIncrement();
    }

    public long getRealTime() {
        return this.realTime;
    }

    public RequestTask getRequestTask() {
        return this.requestTask;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.timeOut - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof Task) {
            Task x = (Task)other;
            long diff = this.timeOut - x.timeOut;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            if (this.sequenceNum < x.sequenceNum) {
                return -1;
            }
            return 1;
        }
        long d = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
        return d == 0L ? 0 : (d < 0L ? -1 : 1);
    }
}

