/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.RestrictTo;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.model.ScanRecord;

public class BleDevice
implements Parcelable {
    public static final int DISCONNECT = 0;
    public static final int CONNECTING = 1;
    public static final int CONNECTED = 2;
    public static final String TAG = BleDevice.class.getSimpleName();
    private static final long serialVersionUID = -2576082824642358033L;
    private int mConnectionState = 0;
    private String mBleAddress;
    private String mBleName;
    private String mBleAlias;
    private boolean mAutoConnect;
    private boolean isAutoConnecting;
    private ScanRecord scanRecord;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Parcelable.Creator<BleDevice> CREATOR = new Parcelable.Creator<BleDevice>(){

        public BleDevice createFromParcel(Parcel in) {
            return new BleDevice(in);
        }

        public BleDevice[] newArray(int size) {
            return new BleDevice[size];
        }
    };

    protected BleDevice(String address, String name) {
        this.mAutoConnect = Ble.options().autoConnect;
        this.isAutoConnecting = false;
        this.mBleAddress = address;
        this.mBleName = name;
    }

    protected BleDevice(Parcel in) {
        this.mAutoConnect = Ble.options().autoConnect;
        this.isAutoConnecting = false;
        this.mConnectionState = in.readInt();
        this.mBleAddress = in.readString();
        this.mBleName = in.readString();
        this.mBleAlias = in.readString();
        this.mAutoConnect = in.readByte() != 0;
        this.isAutoConnecting = in.readByte() != 0;
    }

    public boolean isConnected() {
        return this.mConnectionState == 2;
    }

    public boolean isConnecting() {
        return this.mConnectionState == 1;
    }

    public boolean isDisconnected() {
        return this.mConnectionState == 0;
    }

    public boolean isAutoConnect() {
        return this.mAutoConnect;
    }

    public void setAutoConnect(boolean mAutoConnect) {
        this.mAutoConnect = mAutoConnect;
    }

    public boolean isAutoConnecting() {
        return this.isAutoConnecting;
    }

    public void setAutoConnecting(boolean autoConnecting) {
        this.isAutoConnecting = autoConnecting;
    }

    public int getConnectionState() {
        return this.mConnectionState;
    }

    public void setConnectionState(int state) {
        this.mConnectionState = state;
    }

    public String getBleAddress() {
        return this.mBleAddress;
    }

    public void setBleAddress(String mBleAddress) {
        this.mBleAddress = mBleAddress;
    }

    public String getBleName() {
        return this.mBleName;
    }

    public void setBleName(String mBleName) {
        this.mBleName = mBleName;
    }

    public String getBleAlias() {
        return this.mBleAlias;
    }

    public void setBleAlias(String mBleAlias) {
        this.mBleAlias = mBleAlias;
    }

    public ScanRecord getScanRecord() {
        return this.scanRecord;
    }

    public void setScanRecord(ScanRecord scanRecord) {
        this.scanRecord = scanRecord;
    }

    public String toString() {
        return "BleDevice{mConnectionState=" + this.mConnectionState + ", mBleAddress='" + this.mBleAddress + '\'' + ", mBleName='" + this.mBleName + '\'' + ", mBleAlias='" + this.mBleAlias + '\'' + ", mAutoConnect=" + this.mAutoConnect + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mConnectionState);
        dest.writeString(this.mBleAddress);
        dest.writeString(this.mBleName);
        dest.writeString(this.mBleAlias);
        dest.writeByte((byte)(this.mAutoConnect ? 1 : 0));
        dest.writeByte((byte)(this.isAutoConnecting ? 1 : 0));
    }
}

