/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.callback.wrapper;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import cn.com.heaton.blelibrary.ble.BleLog;
import cn.com.heaton.blelibrary.ble.callback.BleStatusCallback;
import cn.com.heaton.blelibrary.ble.request.ConnectRequest;
import cn.com.heaton.blelibrary.ble.request.Rproxy;
import cn.com.heaton.blelibrary.ble.request.ScanRequest;
import java.lang.ref.WeakReference;

public class BluetoothChangedObserver {
    private BleStatusCallback bleStatusCallback;
    private BleReceiver mBleReceiver;
    private Context mContext;

    public BluetoothChangedObserver(Context context) {
        this.mContext = context;
    }

    public void setBleScanCallbackInner(BleStatusCallback bleStatusCallback) {
        this.bleStatusCallback = bleStatusCallback;
    }

    public void registerReceiver() {
        this.mBleReceiver = new BleReceiver(this);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        this.mContext.registerReceiver((BroadcastReceiver)this.mBleReceiver, filter);
    }

    public void unregisterReceiver() {
        try {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mBleReceiver);
            this.bleStatusCallback = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class BleReceiver
    extends BroadcastReceiver {
        private WeakReference<BluetoothChangedObserver> mObserverWeakReference;

        public BleReceiver(BluetoothChangedObserver bluetoothChangedObserver) {
            this.mObserverWeakReference = new WeakReference<BluetoothChangedObserver>(bluetoothChangedObserver);
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
                BluetoothChangedObserver observer = (BluetoothChangedObserver)this.mObserverWeakReference.get();
                int status = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                if (status == 12) {
                    BleLog.e("", "\u7cfb\u7edf\u84dd\u7259\u5df2\u5f00\u542f");
                    if (observer.bleStatusCallback != null) {
                        observer.bleStatusCallback.onBluetoothStatusChanged(true);
                    }
                    ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
                    request.openBluetooth();
                } else if (status == 10) {
                    ScanRequest scanRequest;
                    BleLog.e("", "\u7cfb\u7edf\u84dd\u7259\u5df2\u5173\u95ed");
                    if (observer.bleStatusCallback != null) {
                        observer.bleStatusCallback.onBluetoothStatusChanged(false);
                    }
                    if ((scanRequest = (ScanRequest)Rproxy.getRequest(ScanRequest.class)).isScanning()) {
                        scanRequest.onStop();
                    }
                    ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
                    request.closeBluetooth();
                }
            }
        }
    }
}

