/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.support.v4.os.HandlerCompat;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.BleHandler;
import cn.com.heaton.blelibrary.ble.BleLog;
import cn.com.heaton.blelibrary.ble.callback.wrapper.ConnectWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.DescWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.MtuWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.NotifyWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.ReadRssiWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.ReadWrapperCallback;
import cn.com.heaton.blelibrary.ble.callback.wrapper.WriteWrapperCallback;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import cn.com.heaton.blelibrary.ble.request.ConnectRequest;
import cn.com.heaton.blelibrary.ble.request.DescriptorRequest;
import cn.com.heaton.blelibrary.ble.request.MtuRequest;
import cn.com.heaton.blelibrary.ble.request.NotifyRequest;
import cn.com.heaton.blelibrary.ble.request.ReadRequest;
import cn.com.heaton.blelibrary.ble.request.ReadRssiRequest;
import cn.com.heaton.blelibrary.ble.request.Rproxy;
import cn.com.heaton.blelibrary.ble.request.WriteRequest;
import cn.com.heaton.blelibrary.ble.utils.ByteUtils;
import cn.com.heaton.blelibrary.ota.OtaListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class BleRequestImpl<T extends BleDevice> {
    private static final String TAG = BleRequestImpl.class.getSimpleName();
    private static BleRequestImpl instance;
    private Handler handler = BleHandler.of();
    private Ble.Options options;
    private Context context;
    private BluetoothAdapter bluetoothAdapter;
    private final Object locker = new Object();
    private List<BluetoothGattCharacteristic> notifyCharacteristics = new ArrayList<BluetoothGattCharacteristic>();
    private int notifyIndex = 0;
    private BluetoothGattCharacteristic otaWriteCharacteristic;
    private boolean otaUpdating = false;
    private Map<String, BluetoothGattCharacteristic> writeCharacteristicMap = new HashMap<String, BluetoothGattCharacteristic>();
    private Map<String, BluetoothGattCharacteristic> readCharacteristicMap = new HashMap<String, BluetoothGattCharacteristic>();
    private Map<String, BluetoothGatt> gattHashMap = new HashMap<String, BluetoothGatt>();
    private List<String> connectedAddressList = new ArrayList<String>();
    private ConnectWrapperCallback<T> connectWrapperCallback;
    private NotifyWrapperCallback<T> notifyWrapperCallback;
    private MtuWrapperCallback<T> mtuWrapperCallback;
    private ReadRssiWrapperCallback<T> readRssiWrapperCallback;
    private ReadWrapperCallback<T> readWrapperCallback;
    private DescWrapperCallback<T> descWrapperCallback;
    private WriteWrapperCallback<T> writeWrapperCallback;
    private OtaListener otaListener;
    private final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            BluetoothDevice device = gatt.getDevice();
            if (device == null) {
                return;
            }
            String address = device.getAddress();
            BleRequestImpl.this.cancelTimeout(address);
            BleDevice bleDevice = BleRequestImpl.this.getBleDeviceInternal(address);
            if (status == 0) {
                if (newState == 2) {
                    BleRequestImpl.this.connectedAddressList.add(device.getAddress());
                    if (BleRequestImpl.this.connectWrapperCallback != null) {
                        bleDevice.setConnectionState(2);
                        BleRequestImpl.this.connectWrapperCallback.onConnectionChanged(bleDevice);
                    }
                    BleLog.d(TAG, "onConnectionStateChange:----device is connected.");
                    BluetoothGatt bluetoothGatt = (BluetoothGatt)BleRequestImpl.this.gattHashMap.get(device.getAddress());
                    if (null != bluetoothGatt) {
                        BleLog.d(TAG, "trying to start service discovery");
                        bluetoothGatt.discoverServices();
                    }
                } else if (newState == 0) {
                    BleLog.d(TAG, "onConnectionStateChange:----device is disconnected.");
                    if (BleRequestImpl.this.connectWrapperCallback != null) {
                        bleDevice.setConnectionState(0);
                        BleRequestImpl.this.connectWrapperCallback.onConnectionChanged(bleDevice);
                    }
                    BleRequestImpl.this.close(device.getAddress());
                }
            } else {
                BleLog.e(TAG, "onConnectionStateChange----: Connection status is abnormal:" + status);
                BleRequestImpl.this.close(device.getAddress());
                if (BleRequestImpl.this.connectWrapperCallback != null) {
                    int errorCode = BleRequestImpl.this.getErrorCode(bleDevice);
                    BleRequestImpl.this.connectWrapperCallback.onConnectException(bleDevice, errorCode);
                    bleDevice.setConnectionState(0);
                    BleRequestImpl.this.connectWrapperCallback.onConnectionChanged(bleDevice);
                }
            }
        }

        @TargetApi(value=21)
        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            if (gatt != null && gatt.getDevice() != null) {
                BleLog.d(TAG, "onMtuChanged mtu=" + mtu + ",status=" + status);
                if (null != BleRequestImpl.this.mtuWrapperCallback) {
                    BleRequestImpl.this.mtuWrapperCallback.onMtuChanged(BleRequestImpl.this.getBleDeviceInternal(gatt.getDevice().getAddress()), mtu, status);
                }
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                BleRequestImpl.this.notifyCharacteristics.clear();
                BleRequestImpl.this.notifyIndex = 0;
                BleRequestImpl.this.displayGattServices(gatt);
            } else {
                BleLog.e(TAG, "onServicesDiscovered received: " + status);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (gatt == null || gatt.getDevice() == null) {
                return;
            }
            BleLog.d(TAG, "onCharacteristicRead:" + status);
            BleDevice bleDevice = BleRequestImpl.this.getBleDeviceInternal(gatt.getDevice().getAddress());
            if (status == 0) {
                if (null != BleRequestImpl.this.readWrapperCallback) {
                    BleRequestImpl.this.readWrapperCallback.onReadSuccess(bleDevice, characteristic);
                }
            } else if (null != BleRequestImpl.this.readWrapperCallback) {
                BleRequestImpl.this.readWrapperCallback.onReadFailed(bleDevice, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (gatt == null || gatt.getDevice() == null) {
                return;
            }
            BleLog.d(TAG, gatt.getDevice().getAddress() + "-----write success----- status: " + status);
            Object object = BleRequestImpl.this.locker;
            synchronized (object) {
                BleDevice bleDevice = BleRequestImpl.this.getBleDeviceInternal(gatt.getDevice().getAddress());
                if (status == 0) {
                    if (null != BleRequestImpl.this.writeWrapperCallback) {
                        BleRequestImpl.this.writeWrapperCallback.onWriteSuccess(bleDevice, characteristic);
                    }
                    if (((BleRequestImpl)BleRequestImpl.this).options.uuid_ota_write_cha.equals(characteristic.getUuid()) && BleRequestImpl.this.otaListener != null) {
                        BleRequestImpl.this.otaListener.onWrite();
                    }
                } else if (null != BleRequestImpl.this.writeWrapperCallback) {
                    BleRequestImpl.this.writeWrapperCallback.onWriteFailed(bleDevice, status);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            Object object = BleRequestImpl.this.locker;
            synchronized (object) {
                if (gatt == null || gatt.getDevice() == null) {
                    return;
                }
                BleLog.d(TAG, gatt.getDevice().getAddress() + " -- onCharacteristicChanged: " + (characteristic.getValue() != null ? ByteUtils.toHexString(characteristic.getValue()) : ""));
                BleDevice bleDevice = BleRequestImpl.this.getBleDeviceInternal(gatt.getDevice().getAddress());
                if (BleRequestImpl.this.notifyWrapperCallback != null) {
                    BleRequestImpl.this.notifyWrapperCallback.onChanged(bleDevice, characteristic);
                }
                if ((((BleRequestImpl)BleRequestImpl.this).options.uuid_ota_write_cha.equals(characteristic.getUuid()) || ((BleRequestImpl)BleRequestImpl.this).options.uuid_ota_notify_cha.equals(characteristic.getUuid())) && BleRequestImpl.this.otaListener != null) {
                    BleRequestImpl.this.otaListener.onChange(characteristic.getValue());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (gatt == null || gatt.getDevice() == null) {
                return;
            }
            UUID uuid = descriptor.getCharacteristic().getUuid();
            BleLog.d(TAG, "write descriptor uuid:" + uuid);
            Object object = BleRequestImpl.this.locker;
            synchronized (object) {
                BleDevice bleDevice = BleRequestImpl.this.getBleDeviceInternal(gatt.getDevice().getAddress());
                if (status == 0) {
                    if (null != BleRequestImpl.this.descWrapperCallback) {
                        BleRequestImpl.this.descWrapperCallback.onDescWriteSuccess(bleDevice, descriptor);
                    }
                    if (BleRequestImpl.this.notifyCharacteristics.size() > 0 && BleRequestImpl.this.notifyIndex < BleRequestImpl.this.notifyCharacteristics.size()) {
                        BleLog.d(TAG, "set characteristic notification, notify_index is " + BleRequestImpl.this.notifyIndex);
                        BleRequestImpl.this.setCharacteristicNotification(gatt.getDevice().getAddress(), true);
                    } else {
                        BleLog.d(TAG, "set characteristic notification is completed");
                        if (BleRequestImpl.this.notifyWrapperCallback != null) {
                            if (Arrays.equals(descriptor.getValue(), BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE) || Arrays.equals(descriptor.getValue(), BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) {
                                BleRequestImpl.this.notifyWrapperCallback.onNotifySuccess(bleDevice);
                            } else if (Arrays.equals(descriptor.getValue(), BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE)) {
                                BleRequestImpl.this.notifyWrapperCallback.onNotifyCanceled(bleDevice);
                            }
                        }
                    }
                } else if (null != BleRequestImpl.this.descWrapperCallback) {
                    BleRequestImpl.this.descWrapperCallback.onDescWriteFailed(bleDevice, status);
                }
            }
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorRead(gatt, descriptor, status);
            if (gatt == null || gatt.getDevice() == null) {
                return;
            }
            UUID uuid = descriptor.getCharacteristic().getUuid();
            BleLog.d(TAG, "read descriptor uuid:" + uuid);
            BleDevice bleDevice = BleRequestImpl.this.getBleDeviceInternal(gatt.getDevice().getAddress());
            if (status == 0) {
                if (null != BleRequestImpl.this.descWrapperCallback) {
                    BleRequestImpl.this.descWrapperCallback.onDescReadSuccess(bleDevice, descriptor);
                }
            } else if (null != BleRequestImpl.this.descWrapperCallback) {
                BleRequestImpl.this.descWrapperCallback.onDescReadFailed(bleDevice, status);
            }
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            BleLog.d(TAG, "read remoteRssi, rssi: " + rssi);
            if (gatt == null || gatt.getDevice() == null) {
                return;
            }
            if (null != BleRequestImpl.this.readRssiWrapperCallback) {
                BleRequestImpl.this.readRssiWrapperCallback.onReadRssiSuccess(BleRequestImpl.this.getBleDeviceInternal(gatt.getDevice().getAddress()), rssi);
            }
        }
    };

    private BleRequestImpl() {
    }

    private int getErrorCode(T bleDevice) {
        if (((BleDevice)bleDevice).isConnected()) {
            return 2033;
        }
        if (((BleDevice)bleDevice).isConnecting()) {
            return 2031;
        }
        return 2032;
    }

    private T getBleDeviceInternal(String address) {
        ConnectRequest request = (ConnectRequest)Rproxy.getRequest(ConnectRequest.class);
        return request.getBleDevice(address);
    }

    public List<BluetoothDevice> getConnectedDevices() {
        BluetoothManager bluetoothManager = (BluetoothManager)this.context.getSystemService("bluetooth");
        if (bluetoothManager != null) {
            return bluetoothManager.getConnectedDevices(7);
        }
        return null;
    }

    public static <T extends BleDevice> BleRequestImpl<T> getBleRequest() {
        if (instance == null) {
            instance = new BleRequestImpl<T>();
        }
        return instance;
    }

    void initialize(Context context) {
        this.connectWrapperCallback = (ConnectWrapperCallback)Rproxy.getRequest(ConnectRequest.class);
        this.notifyWrapperCallback = (NotifyWrapperCallback)Rproxy.getRequest(NotifyRequest.class);
        this.mtuWrapperCallback = (MtuWrapperCallback)Rproxy.getRequest(MtuRequest.class);
        this.readWrapperCallback = (ReadWrapperCallback)Rproxy.getRequest(ReadRequest.class);
        this.readRssiWrapperCallback = (ReadRssiWrapperCallback)Rproxy.getRequest(ReadRssiRequest.class);
        this.writeWrapperCallback = (WriteWrapperCallback)Rproxy.getRequest(WriteRequest.class);
        this.descWrapperCallback = (DescWrapperCallback)Rproxy.getRequest(DescriptorRequest.class);
        this.context = context;
        this.options = Ble.options();
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    void release() {
        this.connectWrapperCallback = null;
        this.mtuWrapperCallback = null;
        this.notifyWrapperCallback = null;
        this.readRssiWrapperCallback = null;
        this.readWrapperCallback = null;
        this.writeWrapperCallback = null;
        this.handler.removeCallbacksAndMessages(null);
        BleLog.d(TAG, "BleRequestImpl is released");
    }

    public void cancelTimeout(String address) {
        this.handler.removeCallbacksAndMessages((Object)address);
    }

    public boolean connect(T bleDevice) {
        String address = ((BleDevice)bleDevice).getBleAddress();
        if (this.connectedAddressList.contains(((BleDevice)bleDevice).getBleAddress()) && ((BleDevice)bleDevice).isConnected()) {
            BleLog.e(TAG, "this is device already connected.");
            this.connectWrapperCallback.onConnectException(bleDevice, 2030);
            return false;
        }
        if (this.bluetoothAdapter == null) {
            BleLog.e(TAG, "bluetoothAdapter not available");
            this.connectWrapperCallback.onConnectException(bleDevice, 2007);
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress((String)address)) {
            BleLog.e(TAG, "the device address is invalid");
            this.connectWrapperCallback.onConnectException(bleDevice, 2010);
            return false;
        }
        BluetoothDevice device = this.bluetoothAdapter.getRemoteDevice(address);
        if (device == null) {
            BleLog.e(TAG, "no device");
            this.connectWrapperCallback.onConnectException(bleDevice, 2041);
            return false;
        }
        HandlerCompat.postDelayed((Handler)this.handler, (Runnable)new Runnable((BleDevice)bleDevice, device){
            final /* synthetic */ BleDevice val$bleDevice;
            final /* synthetic */ BluetoothDevice val$device;
            {
                this.val$bleDevice = bleDevice;
                this.val$device = bluetoothDevice;
            }

            @Override
            public void run() {
                BleRequestImpl.this.connectWrapperCallback.onConnectTimeOut(this.val$bleDevice);
                BleRequestImpl.this.close(this.val$device.getAddress());
            }
        }, (Object)device.getAddress(), (long)this.options.connectTimeout);
        ((BleDevice)bleDevice).setConnectionState(1);
        ((BleDevice)bleDevice).setBleName(device.getName());
        this.connectWrapperCallback.onConnectionChanged(bleDevice);
        BluetoothGatt bluetoothGatt = device.connectGatt(this.context, false, this.gattCallback);
        if (bluetoothGatt != null) {
            this.gattHashMap.put(address, bluetoothGatt);
            BleLog.d(TAG, "Trying to create a new connection.");
            return true;
        }
        return false;
    }

    public void disconnect(String address) {
        if (this.verifyParams(address)) {
            return;
        }
        boolean isValidAddress = BluetoothAdapter.checkBluetoothAddress((String)address);
        if (!isValidAddress) {
            BleLog.e(TAG, "the device address is invalid");
            return;
        }
        this.gattHashMap.get(address).disconnect();
        this.notifyIndex = 0;
        this.notifyCharacteristics.clear();
        this.writeCharacteristicMap.remove(address);
        this.readCharacteristicMap.remove(address);
        this.otaWriteCharacteristic = null;
    }

    public void close(String address) {
        BluetoothGatt gatt = this.gattHashMap.get(address);
        if (gatt != null) {
            gatt.close();
            this.gattHashMap.remove(address);
        }
        this.connectedAddressList.remove(address);
    }

    @TargetApi(value=21)
    public boolean setMtu(String address, int mtu) {
        if (this.verifyParams(address)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21 && mtu > 20 && this.gattHashMap.get(address) != null) {
            boolean result = this.gattHashMap.get(address).requestMtu(mtu);
            BleLog.d(TAG, "requestMTU " + mtu + " result=" + result);
            return result;
        }
        return false;
    }

    public void close() {
        for (String address : this.connectedAddressList) {
            BluetoothGatt gatt = this.gattHashMap.get(address);
            if (gatt == null) continue;
            gatt.close();
        }
        this.gattHashMap.clear();
        this.connectedAddressList.clear();
    }

    public boolean refreshDeviceCache(String address) {
        BluetoothGatt gatt = this.gattHashMap.get(address);
        if (gatt != null) {
            try {
                Method localMethod = gatt.getClass().getMethod("refresh", new Class[0]);
                if (localMethod != null) {
                    boolean bool = (Boolean)localMethod.invoke((Object)gatt, new Object[0]);
                    return bool;
                }
            }
            catch (Exception localException) {
                BleLog.e(TAG, "An exception occured while refreshing device");
            }
        }
        return false;
    }

    public boolean wirteCharacteristic(String address, byte[] value) {
        if (this.verifyParams(address)) {
            return false;
        }
        BluetoothGattCharacteristic gattCharacteristic = this.writeCharacteristicMap.get(address);
        if (gattCharacteristic != null) {
            try {
                if (this.options.uuid_write_cha.equals(gattCharacteristic.getUuid())) {
                    gattCharacteristic.setValue(value);
                    boolean result = this.gattHashMap.get(address).writeCharacteristic(gattCharacteristic);
                    BleLog.d(TAG, address + " -- write result:" + result);
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (null != this.writeWrapperCallback) {
            this.writeWrapperCallback.onWriteFailed(this.getBleDeviceInternal(address), 2045);
        }
        return false;
    }

    public boolean wirteCharacteristicByUuid(String address, byte[] value, UUID serviceUUID, UUID characteristicUUID) {
        if (this.verifyParams(address)) {
            return false;
        }
        BluetoothGatt bluetoothGatt = this.gattHashMap.get(address);
        BluetoothGattCharacteristic characteristic = this.gattCharacteristic(bluetoothGatt, serviceUUID, characteristicUUID);
        if (characteristic != null) {
            try {
                characteristic.setValue(value);
                boolean result = bluetoothGatt.writeCharacteristic(characteristic);
                BleLog.d(TAG, address + " -- write result:" + result);
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public BluetoothGattCharacteristic gattCharacteristic(BluetoothGatt gatt, UUID serviceUUID, UUID characteristicUUID) {
        BluetoothGattService gattService = gatt.getService(serviceUUID);
        if (gattService == null) {
            BleLog.e(TAG, "serviceUUID is null");
            return null;
        }
        BluetoothGattCharacteristic characteristic = gattService.getCharacteristic(characteristicUUID);
        if (characteristic == null) {
            BleLog.e(TAG, "characteristicUUID is null");
            return null;
        }
        return characteristic;
    }

    public boolean readCharacteristic(String address) {
        if (this.verifyParams(address)) {
            return false;
        }
        BluetoothGattCharacteristic gattCharacteristic = this.readCharacteristicMap.get(address);
        if (gattCharacteristic != null) {
            try {
                if (this.options.uuid_read_cha.equals(gattCharacteristic.getUuid())) {
                    boolean result = this.gattHashMap.get(address).readCharacteristic(gattCharacteristic);
                    BleLog.d(TAG, "read result:" + result);
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (null != this.readWrapperCallback) {
            this.readWrapperCallback.onReadFailed(this.getBleDeviceInternal(address), 2045);
        }
        return false;
    }

    public boolean readCharacteristicByUuid(String address, UUID serviceUUID, UUID characteristicUUID) {
        if (this.verifyParams(address)) {
            return false;
        }
        BluetoothGatt bluetoothGatt = this.gattHashMap.get(address);
        BluetoothGattCharacteristic gattCharacteristic = this.gattCharacteristic(bluetoothGatt, serviceUUID, characteristicUUID);
        if (gattCharacteristic != null) {
            try {
                boolean result = bluetoothGatt.readCharacteristic(gattCharacteristic);
                BleLog.d(TAG, address + " -- read result:" + result);
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean readDescriptor(String address, UUID serviceUUID, UUID characteristicUUID, UUID descriptorUUID) {
        if (this.verifyParams(address)) {
            return false;
        }
        BluetoothGatt bluetoothGatt = this.gattHashMap.get(address);
        BluetoothGattCharacteristic gattCharacteristic = this.gattCharacteristic(bluetoothGatt, serviceUUID, characteristicUUID);
        BluetoothGattDescriptor descriptor = gattCharacteristic.getDescriptor(descriptorUUID);
        if (descriptor != null) {
            return this.gattHashMap.get(address).readDescriptor(descriptor);
        }
        return false;
    }

    public boolean writeDescriptor(String address, byte[] data, UUID serviceUUID, UUID characteristicUUID, UUID descriptorUUID) {
        if (this.verifyParams(address)) {
            return false;
        }
        BluetoothGatt bluetoothGatt = this.gattHashMap.get(address);
        BluetoothGattCharacteristic gattCharacteristic = this.gattCharacteristic(bluetoothGatt, serviceUUID, characteristicUUID);
        BluetoothGattDescriptor descriptor = gattCharacteristic.getDescriptor(descriptorUUID);
        if (descriptor != null) {
            descriptor.setValue(data);
            return bluetoothGatt.writeDescriptor(descriptor);
        }
        return false;
    }

    private boolean verifyParams(String address) {
        if (this.bluetoothAdapter == null || this.gattHashMap.get(address) == null) {
            BleLog.e(TAG, "BluetoothAdapter or BluetoothGatt is null");
            return true;
        }
        return false;
    }

    public boolean readRssi(String address) {
        if (this.verifyParams(address)) {
            return false;
        }
        try {
            boolean result = this.gattHashMap.get(address).readRemoteRssi();
            BleLog.d(TAG, address + "read result:" + result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setCharacteristicNotification(String address, boolean enabled) {
        if (this.verifyParams(address)) {
            return;
        }
        if (this.notifyCharacteristics.size() > 0 && this.notifyIndex < this.notifyCharacteristics.size()) {
            BluetoothGattCharacteristic characteristic = this.notifyCharacteristics.get(this.notifyIndex++);
            this.setCharacteristicNotificationInternal(this.gattHashMap.get(address), characteristic, enabled);
        }
    }

    public void setCharacteristicNotificationByUuid(String address, boolean enabled, UUID serviceUUID, UUID characteristicUUID) {
        if (this.verifyParams(address)) {
            return;
        }
        BluetoothGatt bluetoothGatt = this.gattHashMap.get(address);
        BluetoothGattCharacteristic characteristic = this.gattCharacteristic(bluetoothGatt, serviceUUID, characteristicUUID);
        this.setCharacteristicNotificationInternal(bluetoothGatt, characteristic, enabled);
    }

    private void setCharacteristicNotificationInternal(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean enabled) {
        gatt.setCharacteristicNotification(characteristic, enabled);
        if (characteristic.getDescriptors().size() > 0) {
            List descriptors = characteristic.getDescriptors();
            for (BluetoothGattDescriptor descriptor : descriptors) {
                if (descriptor == null) continue;
                if ((characteristic.getProperties() & 0x10) != 0) {
                    descriptor.setValue(enabled ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                } else if ((characteristic.getProperties() & 0x20) != 0) {
                    descriptor.setValue(enabled ? BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                }
                gatt.writeDescriptor(descriptor);
                BleLog.d(TAG, "setCharacteristicNotificationInternal is " + enabled);
            }
        }
    }

    private void displayGattServices(BluetoothGatt gatt) {
        boolean service_uuid_exist = false;
        BluetoothDevice device = gatt.getDevice();
        List gattServices = gatt.getServices();
        if (gattServices == null || device == null) {
            BleLog.e(TAG, "displayGattServices gattServices or device is null");
            if (device != null) {
                this.close(device.getAddress());
            }
            return;
        }
        if (gattServices.isEmpty()) {
            BleLog.e(TAG, "displayGattServices gattServices size is 0");
            this.disconnect(device.getAddress());
            return;
        }
        if (this.connectWrapperCallback != null) {
            T bleDevice = this.getBleDeviceInternal(device.getAddress());
            this.connectWrapperCallback.onServicesDiscovered(bleDevice, gatt);
        }
        for (BluetoothGattService gattService : gattServices) {
            String uuid = gattService.getUuid().toString();
            BleLog.d(TAG, "discovered gattServices: " + uuid);
            if (!uuid.equals(this.options.uuid_service.toString()) && !this.isContainUUID(uuid)) continue;
            service_uuid_exist = true;
            BleLog.i(TAG, "service_uuid is set up successfully:" + uuid);
            List gattCharacteristics = gattService.getCharacteristics();
            for (BluetoothGattCharacteristic gattCharacteristic : gattCharacteristics) {
                int length;
                String char_uuid = gattCharacteristic.getUuid().toString();
                BleLog.d(TAG, "characteristic_uuid: " + char_uuid);
                int charaProp = gattCharacteristic.getProperties();
                StringBuilder properties_builder = new StringBuilder();
                if ((charaProp & 8) != 0) {
                    properties_builder.append("write,");
                }
                if ((charaProp & 4) != 0) {
                    properties_builder.append("write_no_response,");
                }
                if ((charaProp & 2) != 0) {
                    properties_builder.append("read,");
                }
                if ((gattCharacteristic.getProperties() & 0x10) != 0) {
                    this.notifyCharacteristics.add(gattCharacteristic);
                    properties_builder.append("notify,");
                }
                if ((gattCharacteristic.getProperties() & 0x20) != 0) {
                    this.notifyCharacteristics.add(gattCharacteristic);
                    properties_builder.append("indicate,");
                }
                if ((length = properties_builder.length()) > 0) {
                    properties_builder.deleteCharAt(length - 1);
                    BleLog.d(TAG, properties_builder.insert(0, "characteristic properties is ").toString());
                }
                if (char_uuid.equals(this.options.uuid_write_cha.toString())) {
                    BleLog.i(TAG, "write characteristic set up successfully:" + char_uuid);
                    this.writeCharacteristicMap.put(device.getAddress(), gattCharacteristic);
                }
                if (!char_uuid.equals(this.options.uuid_read_cha.toString())) continue;
                BleLog.i(TAG, "read characteristic set up successfully:" + char_uuid);
                this.readCharacteristicMap.put(device.getAddress(), gattCharacteristic);
            }
        }
        if (!service_uuid_exist) {
            BleLog.e(TAG, "init Ble.options().setUuidService(uuid_service) error, and uuid_service not the uuid of your device");
        }
        if (null != this.connectWrapperCallback) {
            this.connectWrapperCallback.onReady(this.getBleDeviceInternal(device.getAddress()));
        }
    }

    private boolean isContainUUID(String uuid) {
        for (UUID u : this.options.uuid_services_extra) {
            if (u == null || !uuid.equals(u.toString())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothGattCharacteristic getWriteCharacteristic(String address) {
        Object object = this.locker;
        synchronized (object) {
            if (this.writeCharacteristicMap != null) {
                return this.writeCharacteristicMap.get(address);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothGattCharacteristic getReadCharacteristic(String address) {
        Object object = this.locker;
        synchronized (object) {
            if (this.readCharacteristicMap != null) {
                return this.readCharacteristicMap.get(address);
            }
            return null;
        }
    }

    public List<BluetoothGattService> getSupportedGattServices(String address) {
        if (this.gattHashMap.get(address) == null) {
            return null;
        }
        return this.gattHashMap.get(address).getServices();
    }

    public BluetoothGatt getBluetoothGatt(String address) {
        return this.gattHashMap.get(address);
    }

    public boolean writeOtaData(String address, byte[] value) {
        if (this.verifyParams(address)) {
            return false;
        }
        try {
            if (this.otaWriteCharacteristic == null) {
                this.otaUpdating = true;
                BluetoothGattService bluetoothGattService = this.gattHashMap.get(address).getService(this.options.uuid_ota_service);
                if (bluetoothGattService == null) {
                    return false;
                }
                BluetoothGattCharacteristic mOtaNotifyCharacteristic = bluetoothGattService.getCharacteristic(this.options.uuid_ota_notify_cha);
                if (mOtaNotifyCharacteristic != null) {
                    this.gattHashMap.get(address).setCharacteristicNotification(mOtaNotifyCharacteristic, true);
                }
                this.otaWriteCharacteristic = bluetoothGattService.getCharacteristic(this.options.uuid_ota_write_cha);
            }
            if (this.otaWriteCharacteristic != null && this.options.uuid_ota_write_cha.equals(this.otaWriteCharacteristic.getUuid())) {
                this.otaWriteCharacteristic.setValue(value);
                boolean result = this.writeCharacteristic(this.gattHashMap.get(address), this.otaWriteCharacteristic);
                BleLog.d(TAG, address + " -- write data:" + Arrays.toString(value));
                BleLog.d(TAG, address + " -- write result:" + result);
                return result;
            }
            return true;
        }
        catch (Exception e) {
            this.close();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeCharacteristic(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
        Object object = this.locker;
        synchronized (object) {
            return gatt != null && characteristic != null && gatt.writeCharacteristic(characteristic);
        }
    }

    public void otaUpdateComplete() {
        this.otaUpdating = false;
    }

    public void setOtaUpdating(boolean updating) {
        this.otaUpdating = updating;
    }

    public void setOtaListener(OtaListener otaListener) {
        this.otaListener = otaListener;
    }
}

