/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble;

import android.text.TextUtils;
import android.util.Log;
import cn.com.heaton.blelibrary.ble.Ble;
import java.util.Locale;

public class BleLog {
    public static String TAG = "AndroidBLE";
    public static boolean isDebug;

    public static void init(Ble.Options options) {
        isDebug = options.logBleEnable;
        if (!TextUtils.isEmpty((CharSequence)options.logTAG)) {
            TAG = options.logTAG;
        }
    }

    private static String getSubTag(Object o) {
        String tag = "";
        tag = o instanceof String ? (String)o : (o instanceof Number ? String.valueOf(o) : o.getClass().getSimpleName());
        return tag;
    }

    public static void e(Object o, String msg) {
        if (isDebug) {
            Log.e((String)TAG, (String)BleLog.buildMessge(BleLog.getSubTag(o), msg));
        }
    }

    public static void i(Object o, String msg) {
        if (isDebug) {
            Log.i((String)TAG, (String)BleLog.buildMessge(BleLog.getSubTag(o), msg));
        }
    }

    public static void w(Object o, String msg) {
        if (isDebug) {
            Log.w((String)TAG, (String)BleLog.buildMessge(BleLog.getSubTag(o), msg));
        }
    }

    public static void d(Object o, String msg) {
        if (isDebug) {
            Log.d((String)TAG, (String)BleLog.buildMessge(BleLog.getSubTag(o), msg));
        }
    }

    private static String buildMessge(String subTag, String msg) {
        return String.format(Locale.CHINA, "[%d] %s: %s", Thread.currentThread().getId(), subTag, msg);
    }

    private static String buildMessage(String format, Object ... args) {
        String msg = args == null ? format : String.format(Locale.CHINA, format, args);
        StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
        String caller = "<unknown>";
        for (int i = 2; i < trace.length; ++i) {
            Class<?> clazz = trace[i].getClass();
            if (clazz.equals(BleLog.class)) continue;
            String callingClass = trace[i].getClassName();
            callingClass = callingClass.substring(callingClass.lastIndexOf(46) + 1);
            callingClass = callingClass.substring(callingClass.lastIndexOf(36) + 1);
            caller = callingClass + "." + trace[i].getMethodName();
            break;
        }
        return String.format(Locale.CHINA, "[%d] %s: %s", Thread.currentThread().getId(), caller, msg);
    }
}

