/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import java.lang.ref.WeakReference;

public class UrlDrawable
extends BitmapDrawable {
    protected Drawable mDrawable;
    protected int mTargetHeight;
    protected WeakReference<TextView> mTextViewRef;
    private String mUrl;

    private UrlDrawable() {
    }

    public UrlDrawable(Drawable drawable) {
        this.mDrawable = drawable;
        if (null != drawable) {
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        }
        this.updateBounds();
    }

    public UrlDrawable(TextView textView) {
        this(textView, null);
    }

    public UrlDrawable(TextView textView, Drawable drawable) {
        this(drawable);
        this.mTextViewRef = new WeakReference<TextView>(textView);
    }

    public void setTargetHeight(int targetHeight) {
        this.mTargetHeight = targetHeight;
    }

    protected int getFontHeight() {
        TextView textView = null;
        if (null != this.mTextViewRef && null != this.mTextViewRef.get()) {
            textView = (TextView)this.mTextViewRef.get();
        }
        if (null == textView) {
            return -1;
        }
        Paint.FontMetricsInt fmPaint = textView.getPaint().getFontMetricsInt();
        return fmPaint.bottom - fmPaint.top;
    }

    public void loadUrl(String url) {
        this.mUrl = url;
    }

    public boolean isGif() {
        return !TextUtils.isEmpty((CharSequence)this.mUrl) && this.mUrl.toLowerCase().endsWith(".gif");
    }

    protected void postInvalidate() {
        TextView textView = null;
        if (null != this.mTextViewRef) {
            textView = (TextView)this.mTextViewRef.get();
        }
        if (null != textView) {
            textView.invalidate();
            textView.setText(textView.getText());
        }
    }

    protected TextView getTextView() {
        return null != this.mTextViewRef ? (TextView)this.mTextViewRef.get() : null;
    }

    protected void release() {
        this.updateDrawable(null);
        if (null != this.mTextViewRef) {
            this.mTextViewRef.clear();
            this.mTextViewRef = null;
        }
    }

    protected void updateDrawable(Drawable d) {
        if (this.mDrawable == d && d != null) {
            return;
        }
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
            this.mDrawable.setVisible(false, false);
        }
        this.mDrawable = d;
        if (d != null) {
            int scaleHeight;
            d.setCallback(new Drawable.Callback(){

                public void invalidateDrawable(@NonNull Drawable who) {
                    TextView textView = UrlDrawable.this.getTextView();
                    if (null == textView) {
                        return;
                    }
                    if (ViewCompat.isAttachedToWindow((View)textView)) {
                        textView.invalidate();
                    }
                }

                public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
                    TextView textView = UrlDrawable.this.getTextView();
                    if (null == textView) {
                        return;
                    }
                    textView.postDelayed(what, when);
                }

                public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
                    TextView textView = UrlDrawable.this.getTextView();
                    if (null == textView) {
                        return;
                    }
                    textView.removeCallbacks(what);
                }
            });
            int width = d.getIntrinsicWidth();
            int height = d.getIntrinsicHeight();
            int targetWidth = width;
            int targetHeight = height;
            int fontHeight = this.getFontHeight();
            if (this.mTargetHeight > 0) {
                scaleHeight = this.mTargetHeight;
            } else {
                int n = scaleHeight = targetHeight > fontHeight ? fontHeight : targetHeight;
            }
            if (scaleHeight > 0) {
                float scale = (float)scaleHeight * 1.0f / (float)height;
                targetHeight = (int)((float)height * scale);
                targetWidth = (int)((float)width * scale);
            }
            d.setBounds(0, 0, targetWidth, targetHeight);
            this.updateBounds();
            d.setVisible(true, true);
            this.postInvalidate();
        }
    }

    protected void updateBounds() {
        if (null != this.mDrawable) {
            this.setBounds(this.mDrawable.getBounds());
        }
    }

    public void draw(Canvas canvas) {
        if (null != this.mDrawable) {
            this.mDrawable.draw(canvas);
        }
    }
}

