/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.text;

import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.SpannedString;
import android.text.style.ImageSpan;
import android.widget.TextView;
import cn.com.lasong.widget.text.UrlDrawable;
import cn.com.lasong.widget.text.VerticalImageSpan;
import java.util.List;

public class SpannableBuilder
extends SpannableStringBuilder {
    public SpannableBuilder() {
    }

    public SpannableBuilder(CharSequence text) {
        super(text);
    }

    public SpannableBuilder(CharSequence text, int start, int end) {
        super(text, start, end);
    }

    public SpannableBuilder appendUrlImage(UrlDrawable drawable) {
        return this.appendUrlImage(drawable, "");
    }

    public SpannableBuilder appendUrlImage(UrlDrawable drawable, String source) {
        int start = this.length();
        this.append("\ufffc");
        int end = this.length();
        this.setSpan((Object)new VerticalImageSpan((Drawable)drawable, source), start, end, 33);
        return this;
    }

    public SpannableBuilder append(CharSequence text, List<Object> spans) {
        this.append(text);
        for (Object span : spans) {
            this.setSpan(span, this.length() - text.length(), this.length(), 33);
        }
        return this;
    }

    public SpannableBuilder append(CharSequence text, Object span) {
        this.append(text);
        this.setSpan(span, this.length() - text.length(), this.length(), 33);
        return this;
    }

    public boolean isImageSpanStart() {
        VerticalImageSpan[] imageSpans = (VerticalImageSpan[])this.getSpans(0, this.length(), VerticalImageSpan.class);
        if (null == imageSpans || imageSpans.length <= 0) {
            return false;
        }
        int startIndex = this.getSpanStart((Object)imageSpans[0]);
        return startIndex == 0;
    }

    public static void release(TextView textView) {
        if (null == textView) {
            return;
        }
        CharSequence text = textView.getText();
        if (text instanceof SpannedString) {
            ImageSpan[] imageSpans2;
            SpannedString spanned = (SpannedString)text;
            VerticalImageSpan[] imageSpans = (VerticalImageSpan[])spanned.getSpans(0, spanned.length(), VerticalImageSpan.class);
            if (null != imageSpans && imageSpans.length > 0) {
                for (VerticalImageSpan span : imageSpans) {
                    Drawable drawable = span.getDrawable();
                    if (!(drawable instanceof UrlDrawable)) continue;
                    ((UrlDrawable)drawable).release();
                }
            }
            if (null != (imageSpans2 = (ImageSpan[])spanned.getSpans(0, spanned.length(), ImageSpan.class)) && imageSpans2.length > 0) {
                for (ImageSpan span : imageSpans2) {
                    Drawable drawable = span.getDrawable();
                    if (null == drawable) continue;
                    drawable.setCallback(null);
                    drawable.setVisible(false, false);
                }
            }
        }
    }
}

