/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.adapterview.helper;

import android.graphics.Canvas;
import android.view.View;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import cn.com.lasong.widget.R;
import cn.com.lasong.widget.adapterview.helper.ItemTouchUIUtil;

class ItemTouchUIUtilImpl {
    ItemTouchUIUtilImpl() {
    }

    static class BaseImpl
    implements ItemTouchUIUtil {
        BaseImpl() {
        }

        @Override
        public void clearView(View view) {
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
        }

        @Override
        public void onSelected(View view) {
        }

        @Override
        public void onDraw(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            view.setTranslationX(dX);
            view.setTranslationY(dY);
        }

        @Override
        public void onDrawOver(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        }
    }

    static class Api21Impl
    extends BaseImpl {
        Api21Impl() {
        }

        @Override
        public void onDraw(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            Object originalElevation;
            if (isCurrentlyActive && (originalElevation = view.getTag(R.id.item_touch_helper_previous_elevation)) == null) {
                originalElevation = Float.valueOf(ViewCompat.getElevation((View)view));
                float newElevation = 1.0f + this.findMaxElevation(recyclerView, view);
                ViewCompat.setElevation((View)view, (float)newElevation);
                view.setTag(R.id.item_touch_helper_previous_elevation, originalElevation);
            }
            super.onDraw(c, recyclerView, view, dX, dY, actionState, isCurrentlyActive);
        }

        private float findMaxElevation(RecyclerView recyclerView, View itemView) {
            int childCount = recyclerView.getChildCount();
            float max = 0.0f;
            for (int i = 0; i < childCount; ++i) {
                float elevation;
                View child = recyclerView.getChildAt(i);
                if (child == itemView || !((elevation = ViewCompat.getElevation((View)child)) > max)) continue;
                max = elevation;
            }
            return max;
        }

        @Override
        public void clearView(View view) {
            Object tag = view.getTag(R.id.item_touch_helper_previous_elevation);
            if (tag != null && tag instanceof Float) {
                ViewCompat.setElevation((View)view, (float)((Float)tag).floatValue());
            }
            view.setTag(R.id.item_touch_helper_previous_elevation, null);
            super.clearView(view);
        }
    }
}

