/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.adapterview.adapter;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

public class Bookends<T extends RecyclerView.Adapter<RecyclerView.ViewHolder>>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final T mBase;
    private static final int HEADER_VIEW_TYPE = -1000;
    private static final int FOOTER_VIEW_TYPE = -2000;
    private static final int LOAD_MORE_ID = -1001;
    private final List<View> mHeaders = new ArrayList<View>();
    private final List<View> mFooters = new ArrayList<View>();

    public Bookends(T base) {
        this.mBase = base;
    }

    public T getWrappedAdapter() {
        return this.mBase;
    }

    public void addHeader(@NonNull View view) {
        if (view == null) {
            throw new IllegalArgumentException("You can't have a null header!");
        }
        this.mHeaders.add(view);
    }

    public void removeHeader(@NonNull View view) {
        if (view == null) {
            throw new IllegalArgumentException("You can't have a null header!");
        }
        this.mHeaders.remove(view);
    }

    public void addFooter(@NonNull View view) {
        if (view == null) {
            throw new IllegalArgumentException("You can't have a null footer!");
        }
        this.mFooters.add(view);
    }

    public void removeFooter(@NonNull View view) {
        if (view == null) {
            throw new IllegalArgumentException("You can't have a null footer!");
        }
        this.mFooters.remove(view);
    }

    public void setHeaderVisibility(boolean shouldShow) {
        for (View header : this.mHeaders) {
            header.setVisibility(shouldShow ? 0 : 8);
        }
    }

    public void setFooterVisibility(boolean shouldShow) {
        for (View footer : this.mFooters) {
            footer.setVisibility(shouldShow ? 0 : 8);
        }
    }

    public int getHeaderCount() {
        return this.mHeaders.size();
    }

    public int getFooterCount() {
        return this.mFooters.size();
    }

    public View getHeader(int i) {
        return i < this.mHeaders.size() ? this.mHeaders.get(i) : null;
    }

    public View getFooter(int i) {
        return i < this.mFooters.size() ? this.mFooters.get(i) : null;
    }

    private boolean isHeader(int viewType) {
        return viewType >= -1000 && viewType < -1000 + this.mHeaders.size();
    }

    private boolean isFooter(int viewType) {
        return viewType >= -2000 && viewType < -2000 + this.mFooters.size();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        if (this.isHeader(viewType)) {
            int whichHeader = Math.abs(viewType - -1000);
            View headerView = this.mHeaders.get(whichHeader);
            return new RecyclerView.ViewHolder(headerView){};
        }
        if (this.isFooter(viewType)) {
            int whichFooter = Math.abs(viewType - -2000);
            View footerView = this.mFooters.get(whichFooter);
            return new RecyclerView.ViewHolder(footerView){};
        }
        return this.mBase.onCreateViewHolder(viewGroup, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (position >= this.mHeaders.size() && position < this.mHeaders.size() + this.mBase.getItemCount()) {
            this.mBase.onBindViewHolder(viewHolder, position - this.mHeaders.size());
        }
    }

    public int getItemCount() {
        return this.mHeaders.size() + this.mBase.getItemCount() + this.mFooters.size();
    }

    public int getItemViewType(int position) {
        if (position < this.mHeaders.size()) {
            return -1000 + position;
        }
        if (position < this.mHeaders.size() + this.mBase.getItemCount()) {
            return this.mBase.getItemViewType(position - this.mHeaders.size());
        }
        return -2000 + position - this.mHeaders.size() - this.mBase.getItemCount();
    }
}

