/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.adapterview.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import cn.com.lasong.widget.adapterview.adapter.OnItemClickListener;
import cn.com.lasong.widget.adapterview.adapter.OnItemLongClickListener;
import java.util.List;

public abstract class ZRecyclerViewAdapter<T>
extends RecyclerView.Adapter<AdapterViewHolder> {
    private List<T> data;
    private int itemLayoutId;
    private OnItemClickListener clickListener;
    private OnItemLongClickListener longClickListener;

    public ZRecyclerViewAdapter(List<T> data, @LayoutRes int itemLayoutId) {
        this.data = data;
        this.itemLayoutId = itemLayoutId;
    }

    public ZRecyclerViewAdapter(List<T> data, @LayoutRes int itemLayoutId, OnItemClickListener clickListener) {
        this.data = data;
        this.itemLayoutId = itemLayoutId;
        this.clickListener = clickListener;
    }

    public ZRecyclerViewAdapter(List<T> data, @LayoutRes int itemLayoutId, OnItemClickListener clickListener, OnItemLongClickListener longClickListener) {
        this.data = data;
        this.itemLayoutId = itemLayoutId;
        this.clickListener = clickListener;
        this.longClickListener = longClickListener;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public AdapterViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.itemLayoutId, parent, false);
        return new AdapterViewHolder(v, this.clickListener, this.longClickListener);
    }

    public void onBindViewHolder(AdapterViewHolder holder, int position) {
        T item = this.data.get(position);
        this.bind(holder, item, position);
    }

    public abstract void bind(AdapterViewHolder var1, T var2, int var3);

    public int getItemCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public static class AdapterViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener,
    Drawable.Callback {
        private SparseArray<View> views;
        private OnItemClickListener clickListener;
        private OnItemLongClickListener longClickListener;
        private SparseArray<TextView> mGifViews;

        public AdapterViewHolder(@NonNull View itemView) {
            this(itemView, null, null);
        }

        public AdapterViewHolder(View itemView, OnItemClickListener clickListener, OnItemLongClickListener longClickListener) {
            super(itemView);
            this.clickListener = clickListener;
            this.longClickListener = longClickListener;
            this.views = new SparseArray();
            itemView.setOnClickListener((View.OnClickListener)this);
            itemView.setOnLongClickListener((View.OnLongClickListener)this);
        }

        public <V extends View> V getView(int viewId) {
            View view = (View)this.views.get(viewId);
            if (view == null) {
                view = this.itemView.findViewById(viewId);
                this.views.put(viewId, (Object)view);
            }
            return (V)view;
        }

        public AdapterViewHolder setText(int viewId, CharSequence text) {
            TextView view = (TextView)this.getView(viewId);
            view.setText(text);
            return this;
        }

        public AdapterViewHolder setTextColor(int viewId, int color) {
            TextView view = (TextView)this.getView(viewId);
            view.setTextColor(color);
            return this;
        }

        public AdapterViewHolder setTextChecked(int viewId, boolean checked) {
            CheckedTextView textView = (CheckedTextView)this.getView(viewId);
            textView.setChecked(checked);
            return this;
        }

        public AdapterViewHolder setText(int viewId, @StringRes int textRes) {
            TextView view = (TextView)this.getView(viewId);
            view.setText(textRes);
            return this;
        }

        public AdapterViewHolder setImageResource(int viewId, @DrawableRes int drawableRes) {
            ImageView view = (ImageView)this.getView(viewId);
            view.setImageResource(drawableRes);
            return this;
        }

        public AdapterViewHolder setGifTextView(int viewId) {
            Object view = this.getView(viewId);
            if (!(view instanceof TextView)) {
                return this;
            }
            if (null == this.mGifViews) {
                this.mGifViews = new SparseArray();
            }
            this.mGifViews.put(viewId, (Object)((TextView)view));
            return this;
        }

        public AdapterViewHolder setBtnBg(int id2, Drawable drawable) {
            Button view = (Button)this.getView(id2);
            view.setBackground(drawable);
            return this;
        }

        public AdapterViewHolder setVisible(boolean visible, int ... ids) {
            for (int id2 : ids) {
                Object v = this.getView(id2);
                v.setVisibility(visible ? 0 : 8);
            }
            return this;
        }

        public AdapterViewHolder setOnClickListener(int ... ids) {
            for (int i : ids) {
                Object v = this.getView(i);
                v.setOnClickListener((View.OnClickListener)this);
            }
            return this;
        }

        public AdapterViewHolder setChecked(int viewid, boolean checked) {
            CheckBox checkBox = (CheckBox)this.getView(viewid);
            checkBox.setChecked(checked);
            return this;
        }

        public AdapterViewHolder setSelected(int viewid, boolean checked) {
            ImageView iv = (ImageView)this.getView(viewid);
            iv.setSelected(checked);
            return this;
        }

        public AdapterViewHolder setOnLongClickListener(int ... ids) {
            for (int i : ids) {
                Object v = this.getView(i);
                if (!v.isLongClickable()) {
                    v.setLongClickable(true);
                }
                v.setOnLongClickListener((View.OnLongClickListener)this);
            }
            return this;
        }

        public void onClick(View v) {
            if (this.clickListener != null) {
                this.clickListener.onItemClick(v, this.getLayoutPosition());
            }
        }

        public boolean onLongClick(View v) {
            if (this.longClickListener != null) {
                this.longClickListener.onItemLongClick(v, this.getLayoutPosition());
            }
            return true;
        }

        public void invalidateDrawable(@NonNull Drawable who) {
            int size = this.mGifViews.size();
            for (int i = 0; i < size; ++i) {
                TextView tv = (TextView)this.mGifViews.valueAt(i);
                if (null == tv || !ViewCompat.isAttachedToWindow((View)tv)) continue;
                tv.invalidate();
            }
        }

        public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
            int size = this.mGifViews.size();
            for (int i = 0; i < size; ++i) {
                TextView tv = (TextView)this.mGifViews.valueAt(i);
                if (null == tv) continue;
                tv.postDelayed(what, when);
            }
        }

        public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
            int size = this.mGifViews.size();
            for (int i = 0; i < size; ++i) {
                TextView tv = (TextView)this.mGifViews.valueAt(i);
                if (null == tv) continue;
                tv.removeCallbacks(what);
            }
        }
    }
}

