/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.adapterview.loadmore;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import cn.com.lasong.widget.adapterview.adapter.Bookends;
import cn.com.lasong.widget.adapterview.loadmore.LoadMoreDefaultFooterView;
import cn.com.lasong.widget.adapterview.loadmore.LoadMoreHandler;
import cn.com.lasong.widget.adapterview.loadmore.LoadMoreUIHandler;
import cn.com.lasong.widget.adapterview.loadmore.ReachEndListener;

public class LmRecyclerView
extends RecyclerView {
    private final String TAG = "LmRecyclerView";
    private Bookends<?> mAdapter;
    private LoadMoreUIHandler mLoadMoreUIHandler;
    private LoadMoreHandler mLoadMoreHandler;
    private boolean mIsLoading;
    private boolean mHasMore = false;
    private boolean mAutoLoadMore = true;
    private boolean mLoadError = false;
    private boolean mListEmpty = true;
    private boolean mShowLoadingForFirstPage = false;
    private View mFooterView;
    private int mFooterTextColor;
    private boolean mEnable = false;
    private boolean debug = false;
    private RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            super.onChanged();
            if (null != LmRecyclerView.this.mAdapter) {
                if (LmRecyclerView.this.debug) {
                    Log.d((String)"LmRecyclerView", (String)"onChanged");
                }
                LmRecyclerView.this.mAdapter.notifyDataSetChanged();
            }
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            if (LmRecyclerView.this.debug) {
                Log.d((String)"LmRecyclerView", (String)("onItemRangeChanged : " + positionStart + "," + itemCount));
            }
            if (null != LmRecyclerView.this.mAdapter) {
                LmRecyclerView.this.mAdapter.notifyItemChanged(positionStart + LmRecyclerView.this.mAdapter.getHeaderCount(), itemCount);
            }
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            if (LmRecyclerView.this.debug) {
                Log.d((String)"LmRecyclerView", (String)("onItemRangeChanged : " + positionStart + "," + itemCount + "," + payload));
            }
            if (null != LmRecyclerView.this.mAdapter) {
                LmRecyclerView.this.mAdapter.notifyItemRangeChanged(positionStart, itemCount, payload);
            }
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            if (LmRecyclerView.this.debug) {
                Log.d((String)"LmRecyclerView", (String)("onItemRangeInserted : " + positionStart + "," + itemCount));
            }
            if (null != LmRecyclerView.this.mAdapter) {
                LmRecyclerView.this.mAdapter.notifyItemRangeInserted(positionStart + LmRecyclerView.this.mAdapter.getHeaderCount(), itemCount);
            }
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            if (LmRecyclerView.this.debug) {
                Log.d((String)"LmRecyclerView", (String)("onItemRangeRemoved : " + positionStart + "," + itemCount));
            }
            if (null != LmRecyclerView.this.mAdapter) {
                LmRecyclerView.this.mAdapter.notifyItemRangeRemoved(positionStart + LmRecyclerView.this.mAdapter.getHeaderCount(), itemCount);
            }
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            if (LmRecyclerView.this.debug) {
                Log.d((String)"LmRecyclerView", (String)("onItemRangeMoved : " + fromPosition + "," + toPosition));
            }
            if (null != LmRecyclerView.this.mAdapter) {
                LmRecyclerView.this.mAdapter.notifyItemMoved(fromPosition, toPosition);
            }
        }
    };

    public LmRecyclerView(Context context) {
        this(context, null);
    }

    public LmRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LmRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mFooterTextColor = Color.parseColor((String)"#b3ffffff");
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.init();
    }

    public void useDefaultFooter() {
        this.mEnable = true;
        LoadMoreDefaultFooterView footerView = new LoadMoreDefaultFooterView(this.getContext());
        footerView.setVisibility(8);
        this.setLoadMoreView((View)footerView);
        this.setLoadMoreUIHandler(footerView);
        footerView.setFooterTextColor(this.mFooterTextColor);
    }

    public void enableLoadMore() {
        this.mEnable = true;
    }

    public void disableLoadMore() {
        this.mEnable = false;
    }

    private void init() {
        this.addOnScrollListener(new ReachEndListener(){

            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (!LmRecyclerView.this.mEnable) {
                    if (LmRecyclerView.this.debug) {
                        Log.w((String)"LmRecyclerView", (String)"LmRecyclerView is not enable");
                    }
                    return;
                }
                if (LmRecyclerView.this.mIsLoading) {
                    if (LmRecyclerView.this.debug) {
                        Log.w((String)"LmRecyclerView", (String)"LmRecyclerView is loading");
                    }
                    return;
                }
                super.onScrollStateChanged(recyclerView, newState);
            }

            @Override
            protected void onReachBottom() {
                LmRecyclerView.this.onReachBottom();
            }
        });
    }

    private void tryToPerformLoadMore() {
        if (this.mIsLoading) {
            return;
        }
        if (!(this.mHasMore || this.mListEmpty && this.mShowLoadingForFirstPage)) {
            return;
        }
        this.mIsLoading = true;
        if (this.mLoadMoreUIHandler != null) {
            this.mLoadMoreUIHandler.onLoading(this);
        }
        if (null != this.mLoadMoreHandler) {
            this.mLoadMoreHandler.onLoadMore(this);
        }
    }

    private void onReachBottom() {
        if (this.mLoadError) {
            return;
        }
        if (this.mAutoLoadMore) {
            this.tryToPerformLoadMore();
        } else if (this.mHasMore) {
            this.mLoadMoreUIHandler.onWaitToLoadMore(this);
        }
    }

    public void setShowLoadingForFirstPage(boolean showLoading) {
        this.mShowLoadingForFirstPage = showLoading;
    }

    public void setAutoLoadMore(boolean autoLoadMore) {
        this.mAutoLoadMore = autoLoadMore;
    }

    public void setLoadMoreView(@NonNull View view) {
        if (null == this.mAdapter) {
            throw new IllegalStateException("must setLmAdapter first");
        }
        if (this.mFooterView != null && this.mFooterView != view) {
            this.mAdapter.removeFooter(this.mFooterView);
        }
        this.mFooterView = view;
        this.mFooterView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LmRecyclerView.this.tryToPerformLoadMore();
            }
        });
        this.mAdapter.addFooter(view);
    }

    public void setLoadMoreUIHandler(LoadMoreUIHandler handler) {
        this.mLoadMoreUIHandler = handler;
    }

    public void setLoadMoreHandler(LoadMoreHandler handler) {
        this.mLoadMoreHandler = handler;
    }

    public void loadMoreFinish(boolean emptyResult, boolean hasMore) {
        this.mLoadError = false;
        this.mListEmpty = emptyResult;
        this.mIsLoading = false;
        this.mHasMore = hasMore;
        if (this.mLoadMoreUIHandler != null) {
            if (hasMore && !this.mAutoLoadMore) {
                this.mLoadMoreUIHandler.onWaitToLoadMore(this);
            } else {
                this.mLoadMoreUIHandler.onLoadFinish(this, emptyResult, hasMore);
            }
        }
    }

    public void loadMoreError(int errorCode, String errorMessage) {
        this.mIsLoading = false;
        this.mLoadError = true;
        if (this.mLoadMoreUIHandler != null) {
            this.mLoadMoreUIHandler.onLoadError(this, errorCode, errorMessage);
        }
    }

    public void addHeader(View view) {
        if (null == this.mAdapter) {
            throw new IllegalStateException("must setLmAdapter first");
        }
        this.mAdapter.addHeader(view);
    }

    public void addFooter(View view) {
        if (null == this.mAdapter) {
            throw new IllegalStateException("must setLmAdapter first");
        }
        if (null != this.mFooterView) {
            throw new IllegalStateException("addFooter must call before setLoadMoreView");
        }
        this.mAdapter.addFooter(view);
    }

    public <T extends RecyclerView.Adapter> void setLmAdapter(T adapter) {
        if (null != this.mAdapter) {
            Object wrapAdapter = this.mAdapter.getWrappedAdapter();
            if (null != wrapAdapter) {
                wrapAdapter.unregisterAdapterDataObserver(this.mDataObserver);
            }
            this.mAdapter.onDetachedFromRecyclerView(this);
        }
        if (null != adapter) {
            this.mAdapter = new Bookends<T>(adapter);
            adapter.registerAdapterDataObserver(this.mDataObserver);
            super.setAdapter(this.mAdapter);
        }
    }

    @Deprecated
    public void setAdapter(RecyclerView.Adapter adapter) {
        if (!this.isInEditMode()) {
            throw new IllegalArgumentException("please call setLmAdapter");
        }
        super.setAdapter(adapter);
    }
}

