/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.lyric;

import android.text.TextUtils;
import android.util.Log;
import cn.com.lasong.widget.lyric.Lyric;
import cn.com.lasong.widget.lyric.LyricLine;
import cn.com.lasong.widget.lyric.LyricWord;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Inflater;

public class LyricUtils {
    private static final String TAG = "LRC";
    private static final char[] MI_ARRAY = new char[]{'@', 'G', 'a', 'w', '^', '2', 't', 'G', 'Q', '6', '1', '-', '\u00ce', '\u00d2', 'n', 'i'};
    private static final String[] REGULAR_PREDIX = new String[]{"id", "ar", "ti", "by", "hash", "al", "sign", "total", "offset"};

    public static byte[] parseLyricFileToByte(String filePath) {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(filePath));
            return LyricUtils.parseLyricFileToByte(fileInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] data) {
        byte[] output;
        Inflater decompresser = new Inflater();
        decompresser.reset();
        decompresser.setInput(data);
        ByteArrayOutputStream o = new ByteArrayOutputStream(data.length);
        try {
            byte[] buf = new byte[1024];
            while (!decompresser.finished()) {
                int i = decompresser.inflate(buf);
                o.write(buf, 0, i);
            }
            output = o.toByteArray();
        }
        catch (Exception e) {
            output = data;
            e.printStackTrace();
        }
        finally {
            try {
                o.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        decompresser.end();
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] parseLyricFileToByte(InputStream in) {
        try {
            byte[] output;
            byte[] zipBytes = new byte[in.available()];
            byte[] topBytes = new byte[4];
            in.read(topBytes);
            in.read(zipBytes);
            int len = zipBytes.length;
            int i = 0;
            while (i < len) {
                int j = i % 16;
                int tmp67_65 = i++;
                byte[] tmp67_64 = zipBytes;
                tmp67_64[tmp67_65] = (byte)(tmp67_64[tmp67_65] ^ MI_ARRAY[j]);
            }
            Inflater decompresser = new Inflater();
            decompresser.reset();
            decompresser.setInput(zipBytes);
            ByteArrayOutputStream o = new ByteArrayOutputStream(zipBytes.length);
            try {
                byte[] buf = new byte[1024];
                while (!decompresser.finished()) {
                    int i2 = decompresser.inflate(buf);
                    o.write(buf, 0, i2);
                }
                output = o.toByteArray();
            }
            catch (Exception e) {
                output = zipBytes;
                e.printStackTrace();
            }
            finally {
                try {
                    o.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            decompresser.end();
            byte[] byArray = output;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static List<String> readLyricList(String filePath) {
        byte[] bytes = LyricUtils.parseLyricFileToByte(filePath);
        if (null == bytes) {
            return null;
        }
        return LyricUtils.readLyricListFromBytes(bytes);
    }

    public static List<String> readLyricList(InputStream in) {
        byte[] bytes = LyricUtils.parseLyricFileToByte(in);
        if (null == bytes) {
            return null;
        }
        return LyricUtils.readLyricListFromBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLyricListFromBytes(byte[] bytes) {
        BufferedReader br = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"readLyc", (Throwable)e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public static Lyric readLyric(InputStream in) {
        List<String> list = LyricUtils.readLyricList(in);
        if (null == list || list.size() <= 0) {
            return null;
        }
        Pattern linePattern = Pattern.compile("\\[(\\d+),(\\d+)](.*)");
        Pattern wordPattern = Pattern.compile("<(\\d+),(\\d+),(\\d+)>([^<]*)");
        Lyric lyric = new Lyric();
        for (String line : list) {
            String string;
            if (line.startsWith("[id:")) {
                lyric.id = line.replace("[id:", "").replace("]", "");
                continue;
            }
            if (line.startsWith("[ar:")) {
                lyric.ar = line.replace("[ar:", "").replace("]", "");
                continue;
            }
            if (line.startsWith("[ti:")) {
                lyric.ti = line.replace("[ti:", "").replace("]", "");
                continue;
            }
            if (line.startsWith("[by:")) {
                lyric.by = line.replace("[by:", "").replace("]", "");
                continue;
            }
            if (line.startsWith("[hash:")) {
                lyric.hash = line.replace("[hash:", "").replace("]", "");
                continue;
            }
            if (line.startsWith("[al:")) {
                lyric.al = line.replace("[al:", "").replace("]", "");
                continue;
            }
            if (line.startsWith("[sign:")) {
                lyric.sign = line.replace("[sign:", "").replace("]", "");
                continue;
            }
            if (line.startsWith("[total:")) {
                string = line.replace("[total:", "").replace("]", "");
                lyric.total = Long.parseLong(string);
                continue;
            }
            if (line.startsWith("[offset:")) {
                string = line.replace("[offset:", "").replace("]", "");
                lyric.offset = Long.parseLong(string);
                continue;
            }
            Matcher lineMatcher = linePattern.matcher(line);
            if (lyric.lines == null) {
                lyric.lines = new ArrayList<LyricLine>();
            }
            if (!lineMatcher.matches()) continue;
            LyricLine lrcLine = new LyricLine();
            lyric.lines.add(lrcLine);
            String lineStart = lineMatcher.group(1);
            String lineDuration = lineMatcher.group(2);
            String lineWords = lineMatcher.group(3);
            lrcLine.start = Long.parseLong(lineStart != null ? lineStart : "0");
            lrcLine.duration = Long.parseLong(lineDuration != null ? lineDuration : "0");
            if (TextUtils.isEmpty((CharSequence)lineWords)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            Matcher wordMatcher = wordPattern.matcher(lineWords);
            while (wordMatcher.find()) {
                LyricWord lrcWord = new LyricWord();
                if (lrcLine.words == null) {
                    lrcLine.words = new ArrayList<LyricWord>();
                }
                lrcLine.words.add(lrcWord);
                String wordStart = wordMatcher.group(1);
                String wordDuration = wordMatcher.group(2);
                String wordOffset = wordMatcher.group(3);
                String word = wordMatcher.group(4);
                lrcWord.start = Long.parseLong(wordStart != null ? wordStart : "0");
                lrcWord.duration = Long.parseLong(wordDuration != null ? wordDuration : "0");
                lrcWord.offset = Long.parseLong(wordOffset != null ? wordOffset : "0");
                lrcWord.word = word;
                stringBuilder.append(word);
            }
            lrcLine.content = stringBuilder.toString();
            long wordDuration = lrcLine.duration;
            if (lrcLine.words != null && lrcLine.words.size() > 0) {
                int index = lrcLine.words.size() - 1;
                LyricWord lastWord = lrcLine.words.get(index);
                wordDuration = Math.min(lastWord.start + lastWord.duration, wordDuration);
            }
            lrcLine.duration = wordDuration;
        }
        return lyric;
    }
}

