/*
 * Decompiled with CFR 0.152.
 */
package cn.com.lasong.widget.dialog;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.math.MathUtils;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.customview.view.AbsSavedState;
import androidx.customview.widget.ViewDragHelper;
import cn.com.lasong.widget.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TopSheetBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int STATE_EXPANDED = 3;
    public static final int STATE_COLLAPSED = 4;
    public static final int STATE_HIDDEN = 5;
    public static final int PEEK_HEIGHT_AUTO = -1;
    public static final int SAVE_PEEK_HEIGHT = 1;
    public static final int SAVE_HIDEABLE = 4;
    public static final int SAVE_ALL = -1;
    public static final int SAVE_NONE = 0;
    private static final String TAG = "BottomSheetBehavior";
    private int saveFlags = 0;
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final float HIDE_FRICTION = 0.1f;
    private static final int CORNER_ANIMATION_DURATION = 500;
    private float maximumVelocity;
    private int peekHeight;
    private boolean peekHeightAuto;
    private SettleRunnable settleRunnable = null;
    int minOffset;
    int maxOffset;
    float elevation = -1.0f;
    boolean hideable;
    int state = 3;
    @Nullable
    ViewDragHelper viewDragHelper;
    private boolean ignoreEvents;
    private int lastNestedScrollDy;
    private boolean nestedScrolled;
    int parentWidth;
    int parentHeight;
    @Nullable
    WeakReference<V> viewRef;
    @Nullable
    WeakReference<View> nestedScrollingChildRef;
    @NonNull
    private final ArrayList<TopSheetCallback> callbacks = new ArrayList();
    @Nullable
    private VelocityTracker velocityTracker;
    int activePointerId;
    private int initialY;
    boolean touchingScrollingChild;
    @Nullable
    private Map<View, Integer> importantForAccessibilityMap;
    private final ViewDragHelper.Callback dragCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(@NonNull View child, int pointerId) {
            if (TopSheetBehavior.this.state == 1) {
                return false;
            }
            if (TopSheetBehavior.this.touchingScrollingChild) {
                return false;
            }
            if (TopSheetBehavior.this.state == 3 && TopSheetBehavior.this.activePointerId == pointerId) {
                View scroll;
                View view = scroll = TopSheetBehavior.this.nestedScrollingChildRef != null ? (View)TopSheetBehavior.this.nestedScrollingChildRef.get() : null;
                if (scroll != null && scroll.canScrollVertically(-1)) {
                    return false;
                }
            }
            return TopSheetBehavior.this.viewRef != null && TopSheetBehavior.this.viewRef.get() == child;
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            TopSheetBehavior.this.dispatchOnSlide(top);
        }

        public void onViewDragStateChanged(int state) {
            if (state == 1) {
                TopSheetBehavior.this.setStateInternal(1);
            }
        }

        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            int targetState;
            int top;
            if (yvel > 0.0f) {
                top = TopSheetBehavior.this.maxOffset;
                targetState = 3;
            } else if (TopSheetBehavior.this.hideable && TopSheetBehavior.this.shouldHide(releasedChild, yvel) && (releasedChild.getTop() < TopSheetBehavior.this.maxOffset || Math.abs(xvel) < Math.abs(yvel))) {
                top = TopSheetBehavior.this.minOffset;
                targetState = 5;
            } else if (yvel == 0.0f || Math.abs(xvel) > Math.abs(yvel)) {
                int currentTop = releasedChild.getTop();
                if (Math.abs(currentTop - TopSheetBehavior.this.minOffset) > Math.abs(currentTop - TopSheetBehavior.this.maxOffset)) {
                    top = TopSheetBehavior.this.maxOffset;
                    targetState = 3;
                } else {
                    top = TopSheetBehavior.this.minOffset;
                    targetState = 4;
                }
            } else {
                top = TopSheetBehavior.this.minOffset;
                targetState = 4;
            }
            TopSheetBehavior.this.startSettlingAnimation(releasedChild, targetState, top, true);
        }

        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            return MathUtils.clamp((int)top, (int)(TopSheetBehavior.this.hideable ? -child.getHeight() : TopSheetBehavior.this.maxOffset), (int)TopSheetBehavior.this.maxOffset);
        }

        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            return child.getLeft();
        }

        public int getViewVerticalDragRange(@NonNull View child) {
            if (TopSheetBehavior.this.hideable) {
                return child.getHeight();
            }
            return TopSheetBehavior.this.maxOffset - TopSheetBehavior.this.minOffset;
        }
    };

    public TopSheetBehavior() {
    }

    public TopSheetBehavior(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedValue value;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TopSheetBehavior_Layout);
        if (Build.VERSION.SDK_INT >= 21) {
            this.elevation = a.getDimension(R.styleable.TopSheetBehavior_Layout_android_elevation, -1.0f);
        }
        if ((value = a.peekValue(R.styleable.TopSheetBehavior_Layout_top_behavior_peekHeight)) != null && value.data == -1) {
            this.setPeekHeight(value.data);
        } else {
            this.setPeekHeight(a.getDimensionPixelSize(R.styleable.TopSheetBehavior_Layout_top_behavior_peekHeight, -1));
        }
        this.setHideable(a.getBoolean(R.styleable.TopSheetBehavior_Layout_top_behavior_hideable, false));
        this.setSaveFlags(a.getInt(R.styleable.TopSheetBehavior_Layout_top_behavior_saveFlags, 0));
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    @NonNull
    public Parcelable onSaveInstanceState(@NonNull CoordinatorLayout parent, @NonNull V child) {
        return new SavedState(super.onSaveInstanceState(parent, child), this);
    }

    public void onRestoreInstanceState(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(parent, child, ss.getSuperState());
        this.restoreOptionalState(ss);
        this.state = ss.state == 1 || ss.state == 2 ? 4 : ss.state;
    }

    public void onAttachedToLayoutParams(@NonNull CoordinatorLayout.LayoutParams layoutParams) {
        super.onAttachedToLayoutParams(layoutParams);
        this.viewRef = null;
        this.viewDragHelper = null;
    }

    public void onDetachedFromLayoutParams() {
        super.onDetachedFromLayoutParams();
        this.viewRef = null;
        this.viewDragHelper = null;
    }

    public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull V child, int layoutDirection) {
        if (ViewCompat.getFitsSystemWindows((View)parent) && !ViewCompat.getFitsSystemWindows(child)) {
            child.setFitsSystemWindows(true);
        }
        if (this.viewRef == null) {
            this.viewRef = new WeakReference<V>(child);
            this.updateAccessibilityActions();
            if (ViewCompat.getImportantForAccessibility(child) == 0) {
                ViewCompat.setImportantForAccessibility(child, (int)1);
            }
            child.setBackgroundColor(0);
        }
        if (this.viewDragHelper == null) {
            this.viewDragHelper = ViewDragHelper.create((ViewGroup)parent, (ViewDragHelper.Callback)this.dragCallback);
        }
        int savedTop = child.getTop();
        parent.onLayoutChild(child, layoutDirection);
        this.parentWidth = parent.getWidth();
        this.parentHeight = parent.getHeight();
        this.minOffset = -child.getHeight();
        this.maxOffset = 0;
        this.calculateCollapsedOffset();
        if (this.state == 3) {
            ViewCompat.offsetTopAndBottom(child, (int)this.maxOffset);
        } else if (this.hideable && this.state == 5) {
            ViewCompat.offsetTopAndBottom(child, (int)(-child.getHeight()));
        } else if (this.state == 4) {
            ViewCompat.offsetTopAndBottom(child, (int)this.minOffset);
        } else if (this.state == 1 || this.state == 2) {
            ViewCompat.offsetTopAndBottom(child, (int)(savedTop - child.getTop()));
        }
        this.nestedScrollingChildRef = new WeakReference<View>(this.findScrollingChild((View)child));
        return true;
    }

    public boolean onInterceptTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!child.isShown()) {
            this.ignoreEvents = true;
            return false;
        }
        int action = event.getActionMasked();
        if (action == 0) {
            this.reset();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        switch (action) {
            case 1: 
            case 3: {
                this.touchingScrollingChild = false;
                this.activePointerId = -1;
                if (!this.ignoreEvents) break;
                this.ignoreEvents = false;
                return false;
            }
            case 0: {
                int initialX = (int)event.getX();
                this.initialY = (int)event.getY();
                if (this.state != 2) {
                    View scroll;
                    View view = scroll = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
                    if (scroll != null && parent.isPointInChildBounds(scroll, initialX, this.initialY)) {
                        this.activePointerId = event.getPointerId(event.getActionIndex());
                        this.touchingScrollingChild = true;
                    }
                }
                this.ignoreEvents = this.activePointerId == -1 && !parent.isPointInChildBounds(child, initialX, this.initialY);
                break;
            }
        }
        if (!this.ignoreEvents && this.viewDragHelper != null && this.viewDragHelper.shouldInterceptTouchEvent(event)) {
            return true;
        }
        View scroll = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
        return action == 2 && scroll != null && !this.ignoreEvents && this.state != 1 && !parent.isPointInChildBounds(scroll, (int)event.getX(), (int)event.getY()) && this.viewDragHelper != null && Math.abs((float)this.initialY - event.getY()) > (float)this.viewDragHelper.getTouchSlop();
    }

    public boolean onTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!child.isShown()) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.state == 1 && action == 0) {
            return true;
        }
        if (this.viewDragHelper != null) {
            this.viewDragHelper.processTouchEvent(event);
        }
        if (action == 0) {
            this.reset();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        if (action == 2 && !this.ignoreEvents && Math.abs((float)this.initialY - event.getY()) > (float)this.viewDragHelper.getTouchSlop()) {
            this.viewDragHelper.captureChildView(child, event.getPointerId(event.getActionIndex()));
        }
        return !this.ignoreEvents;
    }

    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
        this.lastNestedScrollDy = 0;
        this.nestedScrolled = false;
        return (axes & 2) != 0;
    }

    public void onNestedPreScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        View scrollingChild;
        if (type == 1) {
            return;
        }
        View view = scrollingChild = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
        if (target != scrollingChild) {
            return;
        }
        int currentTop = child.getTop();
        int newTop = currentTop - dy;
        if (dy < 0) {
            if (newTop >= this.maxOffset) {
                consumed[1] = currentTop - this.maxOffset;
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                this.setStateInternal(3);
            } else {
                consumed[1] = dy;
                ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                this.setStateInternal(1);
            }
        } else if (dy > 0 && !target.canScrollVertically(-1)) {
            if (newTop >= this.minOffset || this.hideable) {
                consumed[1] = dy;
                ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                this.setStateInternal(1);
            } else {
                consumed[1] = currentTop - this.minOffset;
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                this.setStateInternal(4);
            }
        }
        this.dispatchOnSlide(child.getTop());
        this.lastNestedScrollDy = dy;
        this.nestedScrolled = true;
    }

    public void onStopNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int type) {
        int targetState;
        int top;
        if (child.getTop() == this.maxOffset) {
            this.setStateInternal(3);
            return;
        }
        if (this.nestedScrollingChildRef == null || target != this.nestedScrollingChildRef.get() || !this.nestedScrolled) {
            return;
        }
        if (this.lastNestedScrollDy < 0) {
            top = this.maxOffset;
            targetState = 3;
        } else if (this.hideable && this.shouldHide((View)child, this.getYVelocity())) {
            top = -child.getHeight();
            targetState = 5;
        } else if (this.lastNestedScrollDy == 0) {
            int currentTop = child.getTop();
            if (Math.abs(currentTop - this.minOffset) > Math.abs(currentTop - this.maxOffset)) {
                top = this.maxOffset;
                targetState = 3;
            } else {
                top = this.minOffset;
                targetState = 4;
            }
        } else {
            top = this.minOffset;
            targetState = 4;
        }
        this.startSettlingAnimation((View)child, targetState, top, false);
        this.nestedScrolled = false;
    }

    public void onNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NonNull int[] consumed) {
    }

    public boolean onNestedPreFling(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, float velocityX, float velocityY) {
        if (this.nestedScrollingChildRef != null) {
            return target == this.nestedScrollingChildRef.get() && (this.state != 3 || super.onNestedPreFling(coordinatorLayout, child, target, velocityX, velocityY));
        }
        return false;
    }

    public void setPeekHeight(int peekHeight) {
        this.setPeekHeight(peekHeight, false);
    }

    public final void setPeekHeight(int peekHeight, boolean animate) {
        boolean layout = false;
        if (peekHeight == -1) {
            if (!this.peekHeightAuto) {
                this.peekHeightAuto = true;
                layout = true;
            }
        } else if (this.peekHeightAuto || this.peekHeight != peekHeight) {
            this.peekHeightAuto = false;
            this.peekHeight = Math.max(0, peekHeight);
            layout = true;
        }
        if (layout && this.viewRef != null) {
            View view;
            this.calculateCollapsedOffset();
            if (this.state == 4 && (view = (View)this.viewRef.get()) != null) {
                if (animate) {
                    this.settleToStatePendingLayout(this.state);
                } else {
                    view.requestLayout();
                }
            }
        }
    }

    public int getPeekHeight() {
        return this.peekHeightAuto ? -1 : this.peekHeight;
    }

    public void setHideable(boolean hideable) {
        if (this.hideable != hideable) {
            this.hideable = hideable;
            if (!hideable && this.state == 5) {
                this.setState(4);
            }
            this.updateAccessibilityActions();
        }
    }

    public boolean isHideable() {
        return this.hideable;
    }

    public void setSaveFlags(int flags) {
        this.saveFlags = flags;
    }

    public int getSaveFlags() {
        return this.saveFlags;
    }

    @Deprecated
    public void setBottomSheetCallback(TopSheetCallback callback) {
        Log.w((String)TAG, (String)"BottomSheetBehavior now supports multiple callbacks. `setBottomSheetCallback()` removes all existing callbacks, including ones set internally by library authors, which may result in unintended behavior. This may change in the future. Please use `addBottomSheetCallback()` and `removeBottomSheetCallback()` instead to set your own callbacks.");
        this.callbacks.clear();
        if (callback != null) {
            this.callbacks.add(callback);
        }
    }

    public void addTopSheetCallback(@NonNull TopSheetCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    public void removeTopSheetCallback(@NonNull TopSheetCallback callback) {
        this.callbacks.remove(callback);
    }

    public void setState(int state) {
        if (state == this.state) {
            return;
        }
        if (this.viewRef == null) {
            if (state == 4 || state == 3 || this.hideable && state == 5) {
                this.state = state;
            }
            return;
        }
        this.settleToStatePendingLayout(state);
    }

    private void settleToStatePendingLayout(int state) {
        View child;
        View view = child = null != this.viewRef ? (View)this.viewRef.get() : null;
        if (child == null) {
            return;
        }
        ViewParent parent = child.getParent();
        if (parent != null && parent.isLayoutRequested() && ViewCompat.isAttachedToWindow((View)child)) {
            final int finalState = state;
            child.post(new Runnable(){

                @Override
                public void run() {
                    TopSheetBehavior.this.settleToState(child, finalState);
                }
            });
        } else {
            this.settleToState(child, state);
        }
    }

    public int getState() {
        return this.state;
    }

    void setStateInternal(int state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        if (this.viewRef == null) {
            return;
        }
        View bottomSheet = (View)this.viewRef.get();
        if (bottomSheet == null) {
            return;
        }
        if (state == 3) {
            this.updateImportantForAccessibility(true);
        } else if (state == 5 || state == 4) {
            this.updateImportantForAccessibility(false);
        }
        this.updateDrawableForTargetState(state);
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onStateChanged(bottomSheet, state);
        }
        this.updateAccessibilityActions();
    }

    private void updateDrawableForTargetState(int state) {
        if (state == 2) {
            return;
        }
        boolean expand = state == 3;
    }

    private void calculateCollapsedOffset() {
        View child;
        View view = child = null != this.viewRef ? (View)this.viewRef.get() : null;
        if (null != child) {
            this.minOffset = -child.getHeight();
        }
    }

    private void reset() {
        this.activePointerId = -1;
        if (this.velocityTracker != null) {
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
    }

    private void restoreOptionalState(@NonNull SavedState ss) {
        if (this.saveFlags == 0) {
            return;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 1) == 1) {
            this.peekHeight = ss.peekHeight;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 4) == 4) {
            this.hideable = ss.hideable;
        }
    }

    boolean shouldHide(@NonNull View child, float yvel) {
        if (child.getTop() > this.maxOffset) {
            return false;
        }
        float newTop = (float)child.getTop() + yvel * 0.1f;
        this.peekHeight = this.peekHeight <= 0 ? child.getHeight() : this.peekHeight;
        return Math.abs(newTop - (float)this.maxOffset) / (float)this.peekHeight > 0.5f;
    }

    @Nullable
    @VisibleForTesting
    View findScrollingChild(View view) {
        if (ViewCompat.isNestedScrollingEnabled((View)view)) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                View scrollingChild = this.findScrollingChild(group.getChildAt(i));
                if (scrollingChild == null) continue;
                return scrollingChild;
            }
        }
        return null;
    }

    private float getYVelocity() {
        if (this.velocityTracker == null) {
            return 0.0f;
        }
        this.velocityTracker.computeCurrentVelocity(1000, this.maximumVelocity);
        return this.velocityTracker.getYVelocity(this.activePointerId);
    }

    void settleToState(@NonNull View child, int state) {
        int top;
        if (state == 4) {
            top = this.minOffset;
        } else if (state == 3) {
            top = this.maxOffset;
        } else if (this.hideable && state == 5) {
            top = this.parentHeight;
        } else {
            throw new IllegalArgumentException("Illegal state argument: " + state);
        }
        this.startSettlingAnimation(child, state, top, false);
    }

    void startSettlingAnimation(View child, int state, int top, boolean settleFromViewDragHelper) {
        boolean startedSettling;
        boolean bl = startedSettling = settleFromViewDragHelper ? this.viewDragHelper.settleCapturedViewAt(child.getLeft(), top) : this.viewDragHelper.smoothSlideViewTo(child, child.getLeft(), top);
        if (startedSettling) {
            this.setStateInternal(2);
            this.updateDrawableForTargetState(state);
            if (this.settleRunnable == null) {
                this.settleRunnable = new SettleRunnable(child, state);
            }
            if (!this.settleRunnable.isPosted) {
                this.settleRunnable.targetState = state;
                ViewCompat.postOnAnimation((View)child, (Runnable)this.settleRunnable);
                this.settleRunnable.isPosted = true;
            } else {
                this.settleRunnable.targetState = state;
            }
        } else {
            this.setStateInternal(state);
        }
    }

    void dispatchOnSlide(int top) {
        View bottomSheet = (View)this.viewRef.get();
        if (bottomSheet != null && !this.callbacks.isEmpty()) {
            this.peekHeight = bottomSheet.getHeight();
            float slideOffset = top < this.minOffset ? (float)(top - this.minOffset) / (float)this.peekHeight : (float)(top - this.minOffset) / (float)(this.maxOffset - this.minOffset);
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).onSlide(bottomSheet, slideOffset);
            }
        }
    }

    @NonNull
    public static <V extends View> TopSheetBehavior<V> from(@NonNull V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof TopSheetBehavior)) {
            throw new IllegalArgumentException("The view is not associated with TopSheetBehavior");
        }
        return (TopSheetBehavior)behavior;
    }

    private void updateImportantForAccessibility(boolean expanded) {
        if (this.viewRef == null) {
            return;
        }
        ViewParent viewParent = ((View)this.viewRef.get()).getParent();
        if (!(viewParent instanceof CoordinatorLayout)) {
            return;
        }
        CoordinatorLayout parent = (CoordinatorLayout)viewParent;
        int childCount = parent.getChildCount();
        if (Build.VERSION.SDK_INT >= 16 && expanded) {
            if (this.importantForAccessibilityMap == null) {
                this.importantForAccessibilityMap = new HashMap<View, Integer>(childCount);
            } else {
                return;
            }
        }
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (child == this.viewRef.get()) continue;
            if (!expanded) {
                if (this.importantForAccessibilityMap == null || !this.importantForAccessibilityMap.containsKey(child)) continue;
                ViewCompat.setImportantForAccessibility((View)child, (int)this.importantForAccessibilityMap.get(child));
                continue;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.importantForAccessibilityMap.put(child, child.getImportantForAccessibility());
            }
            ViewCompat.setImportantForAccessibility((View)child, (int)4);
        }
        if (!expanded) {
            this.importantForAccessibilityMap = null;
        }
    }

    private void updateAccessibilityActions() {
        if (this.viewRef == null) {
            return;
        }
        View child = (View)this.viewRef.get();
        if (child == null) {
            return;
        }
        ViewCompat.removeAccessibilityAction((View)child, (int)524288);
        ViewCompat.removeAccessibilityAction((View)child, (int)262144);
        ViewCompat.removeAccessibilityAction((View)child, (int)0x100000);
        if (this.hideable && this.state != 5) {
            this.addAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_DISMISS, 5);
        }
        switch (this.state) {
            case 3: {
                int nextState = 4;
                this.addAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_COLLAPSE, nextState);
                break;
            }
            case 4: {
                int nextState = 3;
                this.addAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_EXPAND, nextState);
                break;
            }
        }
    }

    private void addAccessibilityActionForState(V child, AccessibilityNodeInfoCompat.AccessibilityActionCompat action, final int state) {
        ViewCompat.replaceAccessibilityAction(child, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)action, null, (AccessibilityViewCommand)new AccessibilityViewCommand(){

            public boolean perform(@NonNull View view, @Nullable AccessibilityViewCommand.CommandArguments arguments) {
                TopSheetBehavior.this.setState(state);
                return true;
            }
        });
    }

    protected static class SavedState
    extends AbsSavedState {
        final int state;
        int peekHeight;
        boolean fitToContents;
        boolean hideable;
        boolean skipCollapsed;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Nullable
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(@NonNull Parcel source) {
            this(source, null);
        }

        public SavedState(@NonNull Parcel source, ClassLoader loader) {
            super(source, loader);
            this.state = source.readInt();
            this.peekHeight = source.readInt();
            this.fitToContents = source.readInt() == 1;
            this.hideable = source.readInt() == 1;
            this.skipCollapsed = source.readInt() == 1;
        }

        public SavedState(Parcelable superState, @NonNull TopSheetBehavior<?> behavior) {
            super(superState);
            this.state = behavior.state;
            this.peekHeight = ((TopSheetBehavior)behavior).peekHeight;
            this.hideable = behavior.hideable;
        }

        @Deprecated
        public SavedState(Parcelable superstate, int state) {
            super(superstate);
            this.state = state;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.state);
            out.writeInt(this.peekHeight);
            out.writeInt(this.fitToContents ? 1 : 0);
            out.writeInt(this.hideable ? 1 : 0);
            out.writeInt(this.skipCollapsed ? 1 : 0);
        }
    }

    private class SettleRunnable
    implements Runnable {
        private final View view;
        private boolean isPosted;
        int targetState;

        SettleRunnable(View view, int targetState) {
            this.view = view;
            this.targetState = targetState;
        }

        @Override
        public void run() {
            if (TopSheetBehavior.this.viewDragHelper != null && TopSheetBehavior.this.viewDragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.view, (Runnable)this);
            } else {
                TopSheetBehavior.this.setStateInternal(this.targetState);
            }
            this.isPosted = false;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SaveFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    public static abstract class TopSheetCallback {
        public abstract void onStateChanged(@NonNull View var1, int var2);

        public abstract void onSlide(@NonNull View var1, float var2);
    }
}

