/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.TraceLogger;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class WriterHandler
extends Handler {
    private Writer writerT;
    private boolean doneHeaderT;

    public WriterHandler(Writer inWriterT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setFilter(null);
        this.setLevel(Level.INFO);
        this.writerT = inWriterT;
        this.setFormatter(new SimpleFormatter());
    }

    public WriterHandler(Writer inWriterT, Formatter formatter) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setFilter(null);
        this.setLevel(Level.INFO);
        this.writerT = inWriterT;
        this.setFormatter(formatter);
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        String msg;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.isLoggable(logRecord)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            msg = this.getFormatter().format(logRecord);
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.reportError(null, exception, 5);
            return;
        }
        try {
            if (!this.doneHeaderT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.writerT.write(this.getFormatter().getHead(this));
                this.doneHeaderT = true;
            }
            this.writerT.write(msg);
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.reportError(null, exception, 1);
        }
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.writerT == null || logRecord == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        return super.isLoggable(logRecord);
    }

    @Override
    public synchronized void flush() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.writerT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                this.writerT.flush();
            }
            catch (Exception exception) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.reportError(null, exception, 2);
            }
        }
    }

    private synchronized void flushAndClose_() throws SecurityException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.writerT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                if (!this.doneHeaderT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.writerT.write(this.getFormatter().getHead(this));
                    this.doneHeaderT = true;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.writerT.write(this.getFormatter().getTail(this));
                this.writerT.flush();
                this.writerT.close();
            }
            catch (Exception exception) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.reportError(null, exception, 3);
            }
            this.writerT = null;
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.flushAndClose_();
    }
}

