/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.core.Encoding;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class HStoreConverter {
    public static Map<String, String> fromBytes(byte[] b, Encoding _encoding) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        HashMap<String, String> m = new HashMap<String, String>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int position = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int numElements = ByteConverter.int4(b, position);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        position += 4;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < numElements; ++i) {
                String value;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int _keyLen = ByteConverter.int4(b, position);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String _key = _encoding.decode(b, position += 4, _keyLen);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int valueLen = ByteConverter.int4(b, position += _keyLen);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                position += 4;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (valueLen == -1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    value = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    value = _encoding.decode(b, position, valueLen);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    position += valueLen;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
                m.put(_key, value);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), KSQLState.DATA_ERROR, (Throwable)ioe);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return m;
    }

    public static byte[] toBytes(Map<?, ?> m, Encoding _encoding) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4 + 10 * m.size());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] lengBuf = new byte[4];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ByteConverter.int4(lengBuf, 0, m.size());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            baos.write(lengBuf);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (Map.Entry<?, ?> e : m.entrySet()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] _key = _encoding.encode(e.getKey().toString());
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ByteConverter.int4(lengBuf, 0, _key.length);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                baos.write(lengBuf);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                baos.write(_key);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (e.getValue() == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    ByteConverter.int4(lengBuf, 0, -1);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    baos.write(lengBuf);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] value = _encoding.encode(e.getValue().toString());
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ByteConverter.int4(lengBuf, 0, value.length);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                baos.write(lengBuf);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                baos.write(value);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), KSQLState.DATA_ERROR, (Throwable)ioe);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return baos.toByteArray();
    }

    public static String toString(Map<?, ?> map) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (map.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "";
        }
        StringBuilder sbu = new StringBuilder(map.size() * 8);
        for (Map.Entry<?, ?> e : map.entrySet()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            HStoreConverter.appendEscaped(sbu, e.getKey());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append("=>");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            HStoreConverter.appendEscaped(sbu, e.getValue());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(", ");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.setLength(sbu.length() - 2);
        return sbu.toString();
    }

    private static void appendEscaped(StringBuilder sbu, Object value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (value != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append('\"');
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s = value.toString();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int position = 0; position < s.length(); ++position) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                char chr = s.charAt(position);
                if (chr == '\"' || chr == '\\') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sbu.append('\\');
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.append(chr);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            sbu.append('\"');
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            sbu.append("NULL");
        }
    }

    public static Map<String, String> fromString(String s) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        HashMap<String, String> m = new HashMap<String, String>();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder sbu = new StringBuilder();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int position = 0; position < s.length(); ++position) {
            String value;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.setLength(0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int start = s.indexOf(34, position);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int end = HStoreConverter.appendUntilQuote(sbu, s, start);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _key = sbu.toString();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            position = end + 3;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (s.charAt(position) == 'N') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                value = null;
                position += 4;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.setLength(0);
                end = HStoreConverter.appendUntilQuote(sbu, s, position);
                value = sbu.toString();
                position = end;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            m.put(_key, value);
        }
        return m;
    }

    private static int appendUntilQuote(StringBuilder sbu, String s, int position) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ++position;
        while (position < s.length()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char chr = s.charAt(position);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (chr == '\"') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                break;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (chr == '\\') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                chr = s.charAt(++position);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(chr);
            ++position;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return position;
    }
}

