/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.TraceLogger;
import java.math.BigDecimal;
import java.nio.CharBuffer;
import java.util.logging.Level;

public class ByteConverter {
    private static final short NUMERIC_NEG = 16384;
    private static final int LONG_BYTES = 4;
    private static final int NBASE = 10000;
    private static final int NUMERIC_DSCALE_MASK = 16383;
    private static final short NUMERIC_POS = 0;
    private static final int DEC_DIGITS = 4;
    private static final short NUMERIC_NAN = -16384;
    private static final int[] round_powers = new int[]{0, 1000, 100, 10};
    private static final int SHORT_BYTES = 2;

    private ByteConverter() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static int _bytesToInt(byte[] _bytes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_bytes.length == 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _bytes[0];
        }
        if (_bytes.length == 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ByteConverter.int2(_bytes, 0);
        }
        if (_bytes.length == 4) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ByteConverter.int4(_bytes, 0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new IllegalArgumentException("Argument _bytes is empty");
    }

    private static void digitToString(int index, short[] digits, CharBuffer _buffer, boolean alwaysPutIt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        short digT = index >= 0 && index < digits.length ? digits[index] : (short)0;
        for (int i = 1; i < round_powers.length; ++i) {
            boolean putitT;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int pow = round_powers[i];
            short d1 = (short)(digT / pow);
            digT = (short)(digT - d1 * pow);
            boolean bl = putitT = d1 > 0;
            if (!putitT && !alwaysPutIt) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _buffer.put((char)(d1 + 48));
        }
        _buffer.put((char)(digT + 48));
    }

    private static String numberBytesToString(short[] digits, int scale, int weight, int sign) {
        int dT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int iT = (weight + 1) * 4;
        if (iT <= 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            iT = 1;
        }
        CharBuffer _buffer = CharBuffer.allocate(iT + scale + 4 + 2);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sign == 16384) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _buffer.put('-');
        }
        if (weight < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            dT = weight + 1;
            _buffer.put('0');
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (dT = 0; dT <= weight; ++dT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ByteConverter.digitToString(dT, digits, _buffer, dT != 0);
            }
        }
        if (scale > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _buffer.put('.');
            for (iT = 0; iT < scale; iT += 4) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ByteConverter.digitToString(dT, digits, _buffer, true);
                ++dT;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int extraT = (iT - scale) % 4;
        return new String(_buffer.array(), 0, _buffer.position() - extraT);
    }

    public static Number numeric(byte[] _bytes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ByteConverter.numeric(_bytes, 0, _bytes.length);
    }

    public static Number numeric(byte[] _bytes, int position, int numBytes) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (numBytes < 8) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("number of _bytes should be at-least 8");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int leng = ByteConverter.int2(_bytes, position);
        short weight = ByteConverter.int2(_bytes, position + 2);
        short sign = ByteConverter.int2(_bytes, position + 4);
        short scale = ByteConverter.int2(_bytes, position + 6);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (numBytes != leng * 2 + 8) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("invalid length of _bytes \"numeric\" _value");
        }
        if (sign != 0 && sign != 16384 && sign != -16384) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("invalid sign in \"numeric\" _value");
        }
        if (sign == -16384) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Double.NaN;
        }
        if ((scale & 0x3FFF) != scale) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("invalid scale in \"numeric\" _value");
        }
        short[] digits = new short[leng];
        int index = position + 8;
        for (int i = 0; i < leng; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            short d = ByteConverter.int2(_bytes, index);
            index += 2;
            if (d < 0 || d >= 10000) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new IllegalArgumentException("invalid digit in \"numeric\" _value");
            }
            digits[i] = d;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String numString = ByteConverter.numberBytesToString(digits, scale, weight, sign);
        return new BigDecimal(numString);
    }

    public static long int8(byte[] _bytes, int index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ((long)(_bytes[index + 0] & 0xFF) << 56) + ((long)(_bytes[index + 1] & 0xFF) << 48) + ((long)(_bytes[index + 2] & 0xFF) << 40) + ((long)(_bytes[index + 3] & 0xFF) << 32) + ((long)(_bytes[index + 4] & 0xFF) << 24) + ((long)(_bytes[index + 5] & 0xFF) << 16) + ((long)(_bytes[index + 6] & 0xFF) << 8) + (long)(_bytes[index + 7] & 0xFF);
    }

    public static int int4(byte[] _bytes, int index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ((_bytes[index] & 0xFF) << 24) + ((_bytes[index + 1] & 0xFF) << 16) + ((_bytes[index + 2] & 0xFF) << 8) + (_bytes[index + 3] & 0xFF);
    }

    public static short int2(byte[] _bytes, int index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (short)(((_bytes[index] & 0xFF) << 8) + (_bytes[index + 1] & 0xFF));
    }

    public static byte int1(byte[] _bytes, int index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (byte)(_bytes[index] & 0xFF);
    }

    public static boolean bool(byte[] _bytes, int index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _bytes[index] == 1;
    }

    public static float float4(byte[] _bytes, int index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Float.intBitsToFloat(ByteConverter.int4(_bytes, index));
    }

    public static double float8(byte[] _bytes, int index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Double.longBitsToDouble(ByteConverter.int8(_bytes, index));
    }

    public static void int8(byte[] target, int index, long _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        target[index + 0] = (byte)(_value >>> 56);
        target[index + 1] = (byte)(_value >>> 48);
        target[index + 2] = (byte)(_value >>> 40);
        target[index + 3] = (byte)(_value >>> 32);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        target[index + 4] = (byte)(_value >>> 24);
        target[index + 5] = (byte)(_value >>> 16);
        target[index + 6] = (byte)(_value >>> 8);
        target[index + 7] = (byte)_value;
    }

    public static void int4(byte[] target, int index, int _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        target[index + 0] = (byte)(_value >>> 24);
        target[index + 1] = (byte)(_value >>> 16);
        target[index + 2] = (byte)(_value >>> 8);
        target[index + 3] = (byte)_value;
    }

    public static void int2(byte[] target, int index, int _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        target[index + 0] = (byte)(_value >>> 8);
        target[index + 1] = (byte)_value;
    }

    public static void int1(byte[] target, int index, int _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        target[index] = (byte)_value;
    }

    public static void bool(byte[] target, int index, boolean _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        target[index] = _value ? (byte)1 : 0;
    }

    public static void float4(byte[] target, int index, float _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteConverter.int4(target, index, Float.floatToRawIntBits(_value));
    }

    public static void float8(byte[] target, int index, double _value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteConverter.int8(target, index, Double.doubleToRawLongBits(_value));
    }
}

