/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ssl;

import com.kingbase8.ssl.WrappedFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.TraceLogger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.UUID;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SingleCertValidatingFactory
extends WrappedFactory {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String SYS_PROP_PREFIX = "sys:";
    private static final String ENV_PREFIX = "env:";
    private static final String FILE_PREFIX = "file:";

    public SingleCertValidatingFactory(String sslFactoryArgsT) throws GeneralSecurityException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sslFactoryArgsT == null || sslFactoryArgsT.equals("")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String e1 = "The sslfactoryarg prop may not be empty.";
            throw new GeneralSecurityException(GT.tr(e1, new Object[0]));
        }
        InputStream input = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String encoding = "UTF-8";
        try {
            String name;
            String path;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (sslFactoryArgsT.startsWith(FILE_PREFIX)) {
                path = sslFactoryArgsT.substring(FILE_PREFIX.length());
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                input = new BufferedInputStream(new FileInputStream(path));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            } else if (sslFactoryArgsT.startsWith(CLASSPATH_PREFIX)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                path = sslFactoryArgsT.substring(CLASSPATH_PREFIX.length());
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                input = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(path));
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            } else if (sslFactoryArgsT.startsWith(ENV_PREFIX)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                name = sslFactoryArgsT.substring(ENV_PREFIX.length());
                String certificate = System.getenv(name);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (certificate == null || "".equals(certificate)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String e1 = "The environment variable containing the server's SSL certificateificate must not be empty.";
                    throw new GeneralSecurityException(GT.tr(e1, new Object[0]));
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                input = new ByteArrayInputStream(certificate.getBytes("UTF-8"));
            } else if (sslFactoryArgsT.startsWith(SYS_PROP_PREFIX)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                name = sslFactoryArgsT.substring(SYS_PROP_PREFIX.length());
                String certificate = System.getProperty(name);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (certificate == null || "".equals(certificate)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String e1 = "The system prop containing the server's SSL certificateificate must not be empty.";
                    throw new GeneralSecurityException(GT.tr(e1, new Object[0]));
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                input = new ByteArrayInputStream(certificate.getBytes("UTF-8"));
            } else if (sslFactoryArgsT.startsWith("-----BEGIN CERTIFICATE-----")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                input = new ByteArrayInputStream(sslFactoryArgsT.getBytes("UTF-8"));
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String e1 = "The sslfactoryarg prop must start with the prefix file:, classpath:, env:, sys:, or -----BEGIN CERTIFICATE-----.";
                throw new GeneralSecurityException(GT.tr(e1, new Object[0]));
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            SSLContext context = SSLContext.getInstance("TLS");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            context.init(null, new TrustManager[]{new SingleCertTrustManager(input)}, null);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sslSocketFactory = context.getSocketFactory();
        }
        catch (RuntimeException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw e;
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (e instanceof GeneralSecurityException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw (GeneralSecurityException)e;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new GeneralSecurityException(GT.tr("An error occurred reading the certificateificate", new Object[0]), e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
            }
        }
    }

    public static class SingleCertTrustManager
    implements X509TrustManager {
        X509TrustManager trustMg;
        X509Certificate certificate;

        public SingleCertTrustManager(InputStream input) throws IOException, GeneralSecurityException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KeyStore _keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _keyStore.load(null);
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.certificate = (X509Certificate)cf.generateCertificate(input);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _keyStore.setCertificateEntry(UUID.randomUUID().toString(), this.certificate);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            tmf.init(_keyStore);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.trustMg = (X509TrustManager)tm;
                break;
            }
            if (this.trustMg == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new GeneralSecurityException(GT.tr("No X509TrustManager found", new Object[0]));
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certchain, String authType) throws CertificateException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certchain, String authType) throws CertificateException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.trustMg.checkServerTrusted(certchain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new X509Certificate[]{this.certificate};
        }
    }
}

