/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.jdbc.AbstractTypeInfoCache;
import com.kingbase8.jdbc.KbTypeInfoCache;
import com.kingbase8.jdbc.MysqlTypeInfoCache;
import com.kingbase8.jdbc.SQLServerTypeInfoCache;
import com.kingbase8.jdbc.TypeInfoCache;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

public class TypeInfoCacheFactory {
    private volatile AbstractTypeInfoCache typeInfoCache;

    public TypeInfoCacheFactory(BaseConnection _connection, TypeInfoCache typeInfoCache) {
        this.updateCompatibleLevel(_connection, typeInfoCache);
    }

    public void updateCompatibleLevel(BaseConnection _connection, TypeInfoCache typeinfo) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("mysql".equalsIgnoreCase(_connection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.typeInfoCache = new MysqlTypeInfoCache(typeinfo, _connection);
        } else if ("sqlserver".equalsIgnoreCase(_connection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.typeInfoCache = new SQLServerTypeInfoCache(typeinfo, _connection);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.typeInfoCache = new KbTypeInfoCache(typeinfo, _connection);
        }
    }

    public AbstractTypeInfoCache getTypeInfoCache() {
        return this.typeInfoCache;
    }
}

