/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.KBProperty;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.util.Properties;
import java.util.logging.Level;

public enum SslMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require"),
    VERIFY_CA("verify-ca"),
    VERIFY_FULL("verify-full");

    public final String value;
    public static final SslMode[] VALUES;

    private SslMode(String value) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.value = value;
    }

    public boolean requireEncryption() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.compareTo(REQUIRE) >= 0;
    }

    public boolean verifyCertificate() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this == VERIFY_FULL || this == VERIFY_CA;
    }

    public boolean verifyPeerName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return VERIFY_FULL == this;
    }

    public static SslMode of(Properties infoProps) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String sslmodeT = KBProperty.SSL_MODE.get(infoProps);
        if (sslmodeT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (KBProperty.SSL.getBoolean(infoProps) || "".equals(KBProperty.SSL.get(infoProps))) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return VERIFY_FULL;
            }
            return PREFER;
        }
        for (SslMode sslModeT : VALUES) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!sslModeT.value.equalsIgnoreCase(sslmodeT)) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return sslModeT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Invalid sslmode value: {0}", sslmodeT), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    static {
        VALUES = SslMode.values();
    }
}

