/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;

public class KBpath
extends KBobject
implements Serializable,
Cloneable {
    public boolean open;
    public KBpoint[] points;

    public KBpath(KBpoint[] pointsT, boolean openT) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.open = openT;
        this.points = pointsT;
    }

    public KBpath() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("path");
    }

    public KBpath(String s) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(s);
    }

    @Override
    public void setValue(String value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (value.startsWith("[") && value.endsWith("]")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.open = true;
            value = KBtokenizer.removeBox(value);
        } else if (value.startsWith("(") && value.endsWith(")")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.open = false;
            value = KBtokenizer.removePara(value);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", value), KSQLState.DATA_TYPE_MISMATCH);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBtokenizer t = new KBtokenizer(value, ',');
        int npoints = t.getSize();
        this.points = new KBpoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.points[p] = new KBpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (objt instanceof KBpath) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBpath pnt = (KBpath)objt;
            if (pnt.points.length != this.points.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            if (pnt.open != this.open) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.points[i].equals(pnt.points[i])) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBpath newKBpath = (KBpath)super.clone();
        if (newKBpath.points != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newKBpath.points = (KBpoint[])newKBpath.points.clone();
            for (int i = 0; i < newKBpath.points.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newKBpath.points[i] = (KBpoint)newKBpath.points[i].clone();
            }
        }
        return newKBpath;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int hashVal = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            hashVal ^= this.points[i].hashCode();
        }
        return hashVal;
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder stringBuilder = new StringBuilder(this.open ? "[" : "(");
        for (int i = 0; i < this.points.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stringBuilder.append(",");
            }
            stringBuilder.append(this.points[i].toString());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(this.open ? "]" : ")");
        return stringBuilder.toString();
    }

    public boolean isOpen() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.open;
    }

    public void openPath() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.open = true;
    }

    public void closePath() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.open = false;
    }

    public boolean isClosed() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return !this.open;
    }
}

