/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBlseg;
import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;

public class KBline
extends KBobject
implements Serializable,
Cloneable {
    public double c;
    public double b;
    public double a;

    public KBline(double a, double b, double c) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.c = c;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.a = a;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.b = b;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBline(double xx1, double y1, double x2, double y2) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (xx1 == x2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.a = -1.0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.b = 0.0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.a = (y2 - y1) / (x2 - xx1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.b = -1.0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.c = y1 - this.a * xx1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBline(KBpoint p1, KBpoint p2) {
        this(p1.x, p1.y, p2.x, p2.y);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBline(KBlseg lseg) {
        this(lseg.pointArray[0], lseg.pointArray[1]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBline(String s) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(s);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBline() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("line");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public void setValue(String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s.trim().startsWith("{")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBtokenizer t = new KBtokenizer(KBtokenizer.removeCurlyBrace(s), ',');
            if (t.getSize() != 3) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH);
            }
            this.a = Double.parseDouble(t.getToken(0));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.b = Double.parseDouble(t.getToken(1));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.c = Double.parseDouble(t.getToken(2));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else if (s.trim().startsWith("[")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBtokenizer t = new KBtokenizer(KBtokenizer.removeBox(s), ',');
            if (t.getSize() != 2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH);
            }
            KBpoint p1 = new KBpoint(t.getToken(0));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBpoint point2 = new KBpoint(t.getToken(1));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.a = point2.x - p1.x;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.b = point2.y - p1.y;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.c = p1.y;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this == objt) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        if (objt == null || this.getClass() != objt.getClass()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (!super.equals(objt)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBline pGline = (KBline)objt;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Double.compare(pGline.a, this.a) == 0 && Double.compare(pGline.b, this.b) == 0 && Double.compare(pGline.c, this.c) == 0;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _result = super.hashCode();
        long temp = Double.doubleToLongBits(this.a);
        _result = 31 * _result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _result = 31 * _result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _result = 31 * _result + (int)(temp ^ temp >>> 32);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return super.clone();
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String v = "{" + this.a + "," + this.b + "," + this.c + "}";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return v;
    }
}

