/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.util.CanEstimateSize;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

class BaseQueryKey
implements CanEstimateSize {
    public final String sqlString;
    public final boolean isParameterizedT;
    public final boolean escapeProcessingT;

    BaseQueryKey(String _sql, boolean isParameterized, boolean escapeProcessing) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sqlString = _sql;
        this.isParameterizedT = isParameterized;
        this.escapeProcessingT = escapeProcessing;
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "BaseQueryKey{sqlString='" + this.sqlString + '\'' + ", isParameterizedT=" + this.isParameterizedT + ", escapeProcessingT=" + this.escapeProcessingT + '}';
    }

    @Override
    public long getSize() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.sqlString == null) {
            return 16L;
        }
        return 16L + (long)this.sqlString.length() * 2L;
    }

    public boolean equals(Object o) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        if (this == o) {
            v = true;
            return v;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (null == o || this.getClass() != o.getClass()) {
            v = false;
            return v;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        BaseQueryKey other = (BaseQueryKey)o;
        if (this.isParameterizedT != other.isParameterizedT) {
            return false;
        }
        if (this.escapeProcessingT != other.escapeProcessingT) {
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.sqlString != null ? this.sqlString.equals(other.sqlString) : other.sqlString == null;
    }

    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _result = this.sqlString != null ? this.sqlString.hashCode() : 0;
        _result = 31 * _result + (this.isParameterizedT ? 1 : 0);
        _result = 31 * _result + (this.escapeProcessingT ? 1 : 0);
        return _result;
    }
}

