/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.gss;

import com.kingbase8.core.KBStream;
import com.kingbase8.gss.GSSCallbackHandler;
import com.kingbase8.gss.GssAction;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;

public class MakeGSS {
    public static void authenticate(KBStream kbStream, String _host, String userStr, String password, String jaasAppName, String kerberosServerName, boolean useSpnego, boolean jaasLogin, boolean logServerErrorDetail) throws IOException, SQLException {
        Exception _result;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINEST, " <=BE AuthenticationReqGSS", new Object[0]);
        if (jaasAppName == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            jaasAppName = "kbjdbc";
        }
        if (kerberosServerName == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            kerberosServerName = "kingbase8";
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean performAuth = jaasLogin;
            GSSCredential gssCredential = null;
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Set<GSSCredential> gssCredsSet = subject.getPrivateCredentials(GSSCredential.class);
                if (!gssCredsSet.isEmpty() && gssCredsSet != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    gssCredential = gssCredsSet.iterator().next();
                    performAuth = false;
                }
            }
            if (performAuth) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                LoginContext loginContext = new LoginContext(jaasAppName, new GSSCallbackHandler(userStr, password));
                loginContext.login();
                subject = loginContext.getSubject();
            }
            GssAction action = new GssAction(kbStream, gssCredential, _host, userStr, kerberosServerName, useSpnego, logServerErrorDetail);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _result = Subject.doAs(subject, action);
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("GSS Authentication failed", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (_result instanceof IOException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw (IOException)_result;
        }
        if (_result instanceof SQLException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw (SQLException)_result;
        }
        if (_result != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("GSS Authentication failed", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)_result);
        }
    }
}

