//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.rights.v1_0_0.request;

import cn.com.antcloud.api.product.AntCloudProdRequest;
import cn.com.antcloud.api.rights.v1_0_0.response.QueryRightsDirectResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 直接查询外部查询接口 */
public class QueryRightsDirectRequest extends AntCloudProdRequest<QueryRightsDirectResponse> {
  @NotNull
  private String actId;

  private String couponId;

  @NotNull
  private String equityInst;

  private String extString;

  @NotNull
  private String pageNo;

  @NotNull
  private String pageSize;

  private String status;

  @NotNull
  private String userId;

  public QueryRightsDirectRequest(String productInstanceId) {
    super("bpaas.rights.rights.direct.query", "1.0", "Java-SDK-20201013", productInstanceId);
  }

  public QueryRightsDirectRequest() {
    super("bpaas.rights.rights.direct.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20201013");
  }

  /**
   * 活动id */
  public String getActId() {
    return this.actId;
  }

  /**
   * 活动id */
  public void setActId(String actId) {
    this.actId = actId;
  }

  /**
   * 券id,可选,填了券id就是单个查询 */
  public String getCouponId() {
    return this.couponId;
  }

  /**
   * 券id,可选,填了券id就是单个查询 */
  public void setCouponId(String couponId) {
    this.couponId = couponId;
  }

  /**
   * 权益结构id */
  public String getEquityInst() {
    return this.equityInst;
  }

  /**
   * 权益结构id */
  public void setEquityInst(String equityInst) {
    this.equityInst = equityInst;
  }

  /**
   * 定制化或者扩展参数 */
  public String getExtString() {
    return this.extString;
  }

  /**
   * 定制化或者扩展参数 */
  public void setExtString(String extString) {
    this.extString = extString;
  }

  /**
   * 默认为1 */
  public String getPageNo() {
    return this.pageNo;
  }

  /**
   * 默认为1 */
  public void setPageNo(String pageNo) {
    this.pageNo = pageNo;
  }

  /**
   * 每页20个数据 */
  public String getPageSize() {
    return this.pageSize;
  }

  /**
   * 每页20个数据 */
  public void setPageSize(String pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 不传查询全部 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 不传查询全部 */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 用户id */
  public String getUserId() {
    return this.userId;
  }

  /**
   * 用户id */
  public void setUserId(String userId) {
    this.userId = userId;
  }
}
