//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.rights.v1_0_0.request;

import cn.com.antcloud.api.product.AntCloudProdRequest;
import cn.com.antcloud.api.rights.v1_0_0.response.QueryArrangementResponse;
import java.lang.String;

/**
 * 查询指定金融云账户下的合约 */
public class QueryArrangementRequest extends AntCloudProdRequest<QueryArrangementResponse> {
  private String arStatus;

  public QueryArrangementRequest(String productInstanceId) {
    super("bpaas.rights.arrangement.query", "1.0", "Java-SDK-20201013", productInstanceId);
  }

  public QueryArrangementRequest() {
    super("bpaas.rights.arrangement.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20201013");
  }

  /**
   * 合约状态 */
  public String getArStatus() {
    return this.arStatus;
  }

  /**
   * 合约状态 */
  public void setArStatus(String arStatus) {
    this.arStatus = arStatus;
  }
}
