//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.rights.v1_0_0.request;

import cn.com.antcloud.api.product.AntCloudProdRequest;
import cn.com.antcloud.api.rights.v1_0_0.response.ExecRightsPayResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 权益核销接口
 * 分成两种模式:
 * 1 notice 被动接受核销结果通知
 * 2. pay 主动进行权益核销 */
public class ExecRightsPayRequest extends AntCloudProdRequest<ExecRightsPayResponse> {
  @NotNull
  private Long amount;

  private String couponId;

  @NotNull
  private String equityArCode;

  @NotNull
  private String equityPayNo;

  @NotNull
  private Date equityPayTime;

  @NotNull
  private String equityPdCode;

  @NotNull
  private String mainInstCode;

  @NotNull
  private String outTradeNo;

  @NotNull
  private String payType;

  @NotNull
  private String subInstCode;

  @NotNull
  private Boolean success;

  @NotNull
  private String userId;

  public ExecRightsPayRequest(String productInstanceId) {
    super("bpaas.rights.rights.pay.exec", "1.0", "Java-SDK-20201013", productInstanceId);
  }

  public ExecRightsPayRequest() {
    super("bpaas.rights.rights.pay.exec", "1.0", null);
    this.setSdkVersion("Java-SDK-20201013");
  }

  /**
   * 核销金额
   * 传入当前币种的最小单位的数字
   * 比如1块人民币,传入数字为100 */
  public Long getAmount() {
    return this.amount;
  }

  /**
   * 核销金额
   * 传入当前币种的最小单位的数字
   * 比如1块人民币,传入数字为100 */
  public void setAmount(Long amount) {
    this.amount = amount;
  }

  /**
   * 当pay_type == pay时必填
   * 权益id */
  public String getCouponId() {
    return this.couponId;
  }

  /**
   * 当pay_type == pay时必填
   * 权益id */
  public void setCouponId(String couponId) {
    this.couponId = couponId;
  }

  /**
   * 权益合约号
   */
  public String getEquityArCode() {
    return this.equityArCode;
  }

  /**
   * 权益合约号
   */
  public void setEquityArCode(String equityArCode) {
    this.equityArCode = equityArCode;
  }

  /**
   * 借据流水号 */
  public String getEquityPayNo() {
    return this.equityPayNo;
  }

  /**
   * 借据流水号 */
  public void setEquityPayNo(String equityPayNo) {
    this.equityPayNo = equityPayNo;
  }

  /**
   * 权益核销时间 */
  public Date getEquityPayTime() {
    return this.equityPayTime;
  }

  /**
   * 权益核销时间 */
  public void setEquityPayTime(Date equityPayTime) {
    this.equityPayTime = equityPayTime;
  }

  /**
   * 权益产品码 */
  public String getEquityPdCode() {
    return this.equityPdCode;
  }

  /**
   * 权益产品码 */
  public void setEquityPdCode(String equityPdCode) {
    this.equityPdCode = equityPdCode;
  }

  /**
   * 权益机构号 */
  public String getMainInstCode() {
    return this.mainInstCode;
  }

  /**
   * 权益机构号 */
  public void setMainInstCode(String mainInstCode) {
    this.mainInstCode = mainInstCode;
  }

  /**
   * 外部交易流水号
   */
  public String getOutTradeNo() {
    return this.outTradeNo;
  }

  /**
   * 外部交易流水号
   */
  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  /**
   * notice:被动接收核销结果
   * pay:主动权益核销 */
  public String getPayType() {
    return this.payType;
  }

  /**
   * notice:被动接收核销结果
   * pay:主动权益核销 */
  public void setPayType(String payType) {
    this.payType = payType;
  }

  /**
   * 子机构号
   */
  public String getSubInstCode() {
    return this.subInstCode;
  }

  /**
   * 子机构号
   */
  public void setSubInstCode(String subInstCode) {
    this.subInstCode = subInstCode;
  }

  /**
   * 当payType == notice时必填
   * 核销结果 */
  public Boolean getSuccess() {
    return this.success;
  }

  /**
   * 当payType == notice时必填
   * 核销结果 */
  public void setSuccess(Boolean success) {
    this.success = success;
  }

  /**
   * 用户id */
  public String getUserId() {
    return this.userId;
  }

  /**
   * 用户id */
  public void setUserId(String userId) {
    this.userId = userId;
  }
}
