//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.rights.v1_0_0.response;

import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.String;
import java.util.Date;

/**
 * 权益发放状态查询接口
 *
 * 测试时使用product_id为: ACW3TLBVP4UWIP3RPCB0
 *
 * ak使用:LTAIrZBs9jvy9LKY
 * sk使用:dYdGS5fA6d9oYyiie6tb0s9UoDQtRm */
public class QueryRightsResponse extends AntCloudProdResponse {
  private String grantResult;

  private Date grantTime;

  private String outTradeNo;

  private String tradeNo;

  /**
   * 发放结果
   * ungranted - 未发放
   * granted - 已发放 */
  public String getGrantResult() {
    return this.grantResult;
  }

  /**
   * 发放结果
   * ungranted - 未发放
   * granted - 已发放 */
  public void setGrantResult(String grantResult) {
    this.grantResult = grantResult;
  }

  /**
   * 发放时间,格式:yyyy-MM-dd HH:m m :ss */
  public Date getGrantTime() {
    return this.grantTime;
  }

  /**
   * 发放时间,格式:yyyy-MM-dd HH:m m :ss */
  public void setGrantTime(Date grantTime) {
    this.grantTime = grantTime;
  }

  /**
   * 外部订单号，透传 */
  public String getOutTradeNo() {
    return this.outTradeNo;
  }

  /**
   * 外部订单号，透传 */
  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  /**
   * 交易中心内部订单号 */
  public String getTradeNo() {
    return this.tradeNo;
  }

  /**
   * 交易中心内部订单号 */
  public void setTradeNo(String tradeNo) {
    this.tradeNo = tradeNo;
  }
}
