//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.rights.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 错误编码 */
public class ErrorCode {
  @NotNull
  private String errorLevel;

  @NotNull
  private String errorPrefix;

  @NotNull
  private String errorScene;

  @NotNull
  private String errorSpecific;

  @NotNull
  private String errorType;

  @NotNull
  private String version;

  /**
   * 错误级别[第4位] */
  public String getErrorLevel() {
    return this.errorLevel;
  }

  /**
   * 错误级别[第4位] */
  public void setErrorLevel(String errorLevel) {
    this.errorLevel = errorLevel;
  }

  /**
   * 错误前缀 */
  public String getErrorPrefix() {
    return this.errorPrefix;
  }

  /**
   * 错误前缀 */
  public void setErrorPrefix(String errorPrefix) {
    this.errorPrefix = errorPrefix;
  }

  /**
   * 错误场景：版本1[第6-9位]，版本2[第6-13位] */
  public String getErrorScene() {
    return this.errorScene;
  }

  /**
   * 错误场景：版本1[第6-9位]，版本2[第6-13位] */
  public void setErrorScene(String errorScene) {
    this.errorScene = errorScene;
  }

  /**
   * 具体错误码：版本1[第10-12位]，版本2[第14-16位] */
  public String getErrorSpecific() {
    return this.errorSpecific;
  }

  /**
   * 具体错误码：版本1[第10-12位]，版本2[第14-16位] */
  public void setErrorSpecific(String errorSpecific) {
    this.errorSpecific = errorSpecific;
  }

  /**
   * 错误类型[第5位] */
  public String getErrorType() {
    return this.errorType;
  }

  /**
   * 错误类型[第5位] */
  public void setErrorType(String errorType) {
    this.errorType = errorType;
  }

  /**
   * 规范版本[第3位] */
  public String getVersion() {
    return this.version;
  }

  /**
   * 规范版本[第3位] */
  public void setVersion(String version) {
    this.version = version;
  }
}
