//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.rights.v1_0_0.response;

import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.Boolean;
import java.lang.String;
import java.util.Date;

/**
 * 权益发放接口，分为两种模式 */
public class ExecRightsResponse extends AntCloudProdResponse {
  private String grantResult;

  private Date grantTime;

  private Boolean needRetry;

  private String outTradeNo;

  private String resultExtInfo;

  private String tradeNo;

  private Date tradeTime;

  /**
   * 发放结果 */
  public String getGrantResult() {
    return this.grantResult;
  }

  /**
   * 发放结果 */
  public void setGrantResult(String grantResult) {
    this.grantResult = grantResult;
  }

  /**
   * 权益发放时间
   * 实时发放的场景会有发放时间
   * 异步发放该字段为空 */
  public Date getGrantTime() {
    return this.grantTime;
  }

  /**
   * 权益发放时间
   * 实时发放的场景会有发放时间
   * 异步发放该字段为空 */
  public void setGrantTime(Date grantTime) {
    this.grantTime = grantTime;
  }

  /**
   * 是否重试 */
  public Boolean getNeedRetry() {
    return this.needRetry;
  }

  /**
   * 是否重试 */
  public void setNeedRetry(Boolean needRetry) {
    this.needRetry = needRetry;
  }

  /**
   * 外部订单号 */
  public String getOutTradeNo() {
    return this.outTradeNo;
  }

  /**
   * 外部订单号 */
  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  /**
   * 结果扩展jsonString */
  public String getResultExtInfo() {
    return this.resultExtInfo;
  }

  /**
   * 结果扩展jsonString */
  public void setResultExtInfo(String resultExtInfo) {
    this.resultExtInfo = resultExtInfo;
  }

  /**
   * 权益平台返回的交易订单号 */
  public String getTradeNo() {
    return this.tradeNo;
  }

  /**
   * 权益平台返回的交易订单号 */
  public void setTradeNo(String tradeNo) {
    this.tradeNo = tradeNo;
  }

  /**
   * 交易时间，权益平台接受小请求的时间 */
  public Date getTradeTime() {
    return this.tradeTime;
  }

  /**
   * 交易时间，权益平台接受小请求的时间 */
  public void setTradeTime(Date tradeTime) {
    this.tradeTime = tradeTime;
  }
}
