//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.rights.v1_0_0.request;

import cn.com.antcloud.api.product.AntCloudProdRequest;
import cn.com.antcloud.api.rights.v1_0_0.response.QueryRightsResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 权益发放状态查询接口 */
public class QueryRightsRequest extends AntCloudProdRequest<QueryRightsResponse> {
  @NotNull
  private String mainInstCode;

  @NotNull
  private String outTradeNo;

  public QueryRightsRequest(String productInstanceId) {
    super("bpaas.rights.rights.query", "1.0", "Java-SDK-20191107", productInstanceId);
  }

  public QueryRightsRequest() {
    super("bpaas.rights.rights.query", "1.0", null);
    this.setSdkVersion("Java-SDK-20191107");
  }

  /**
   * 主机构号 */
  public String getMainInstCode() {
    return this.mainInstCode;
  }

  /**
   * 主机构号 */
  public void setMainInstCode(String mainInstCode) {
    this.mainInstCode = mainInstCode;
  }

  /**
   * 外部订单号 */
  public String getOutTradeNo() {
    return this.outTradeNo;
  }

  /**
   * 外部订单号 */
  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }
}
