//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.rights.v1_0_0.request;

import cn.com.antcloud.api.product.AntCloudProdRequest;
import cn.com.antcloud.api.rights.v1_0_0.response.ExecRightsResponse;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 权益发放接口，分为两种模式 */
public class ExecRightsRequest extends AntCloudProdRequest<ExecRightsResponse> {
  @NotNull
  private String equityAccount;

  @NotNull
  private String equityAccountType;

  @NotNull
  private String equityArNo;

  @NotNull
  private String equityPdCode;

  private String extString;

  @NotNull
  private String mainInstCode;

  @NotNull
  private String outTradeNo;

  private String subInstCode;

  public ExecRightsRequest(String productInstanceId) {
    super("bpaas.rights.rights.exec", "1.0", "Java-SDK-20191107", productInstanceId);
  }

  public ExecRightsRequest() {
    super("bpaas.rights.rights.exec", "1.0", null);
    this.setSdkVersion("Java-SDK-20191107");
  }

  /**
   * 权益发放到具体的账户
   * 实例：
   * email类型：1234@gmail.com
   * telephone类型：15605880000 */
  public String getEquityAccount() {
    return this.equityAccount;
  }

  /**
   * 权益发放到具体的账户
   * 实例：
   * email类型：1234@gmail.com
   * telephone类型：15605880000 */
  public void setEquityAccount(String equityAccount) {
    this.equityAccount = equityAccount;
  }

  /**
   * 发放的权益账号类型
   * email：邮箱
   * telephone：手机号 */
  public String getEquityAccountType() {
    return this.equityAccountType;
  }

  /**
   * 发放的权益账号类型
   * email：邮箱
   * telephone：手机号 */
  public void setEquityAccountType(String equityAccountType) {
    this.equityAccountType = equityAccountType;
  }

  /**
   * 权益产品合约号 */
  public String getEquityArNo() {
    return this.equityArNo;
  }

  /**
   * 权益产品合约号 */
  public void setEquityArNo(String equityArNo) {
    this.equityArNo = equityArNo;
  }

  /**
   * 权益产品码 */
  public String getEquityPdCode() {
    return this.equityPdCode;
  }

  /**
   * 权益产品码 */
  public void setEquityPdCode(String equityPdCode) {
    this.equityPdCode = equityPdCode;
  }

  /**
   * 扩展字段的jsonString */
  public String getExtString() {
    return this.extString;
  }

  /**
   * 扩展字段的jsonString */
  public void setExtString(String extString) {
    this.extString = extString;
  }

  /**
   * 主机构号 */
  public String getMainInstCode() {
    return this.mainInstCode;
  }

  /**
   * 主机构号 */
  public void setMainInstCode(String mainInstCode) {
    this.mainInstCode = mainInstCode;
  }

  /**
   * 外部交易订单号
   * 幂等单号 */
  public String getOutTradeNo() {
    return this.outTradeNo;
  }

  /**
   * 外部交易订单号
   * 幂等单号 */
  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  /**
   * 子机构号 */
  public String getSubInstCode() {
    return this.subInstCode;
  }

  /**
   * 子机构号 */
  public void setSubInstCode(String subInstCode) {
    this.subInstCode = subInstCode;
  }
}
