//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.response;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderResponse;
import cn.com.antcloud.api.provider.sas.v1_0_0.model.ServerlessAppServiceDetailInfo;
import java.lang.Long;
import java.util.List;

/**
 * 分页查询应用实例的基本信息
 */
public class QueryServerlessappserviceResponse extends AntCloudProviderResponse<QueryServerlessappserviceResponse> {
  private Long pageNum;

  private Long pageSize;

  private List<ServerlessAppServiceDetailInfo> serverlessAppServices;

  private Long totalCount;

  /**
   * 查询页大小 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 查询页大小 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 当前页号，起始为1 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 当前页号，起始为1 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 应用实例信息 */
  public List<ServerlessAppServiceDetailInfo> getServerlessAppServices() {
    return this.serverlessAppServices;
  }

  /**
   * 应用实例信息 */
  public void setServerlessAppServices(List<ServerlessAppServiceDetailInfo> serverlessAppServices) {
    this.serverlessAppServices = serverlessAppServices;
  }

  /**
   * 查询结果总个数 */
  public Long getTotalCount() {
    return this.totalCount;
  }

  /**
   * 查询结果总个数 */
  public void setTotalCount(Long totalCount) {
    this.totalCount = totalCount;
  }
}
