//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.QueryServerlessappserviceVersionResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 查询版本
 */
public class QueryServerlessappserviceVersionRequest extends AntCloudProviderRequest<QueryServerlessappserviceVersionResponse> {
  @NotNull
  private String appServiceName;

  private List<String> creatorIds;

  private List<String> fullVersions;

  private String fullVersionLike;

  private Long pageNum;

  private Long pageSize;

  private Long routeWeightPercentFrom;

  private Long routeWeightPercentTo;

  private List<String> runtimeIdentities;

  private Boolean shared;

  private List<String> specIdentities;

  @NotNull
  private String workspace;

  public QueryServerlessappserviceVersionRequest() {
    super("antcloud.sas.serverlessappservice.version.query", "1.0", "Java-SDK-20190410");
  }

  /**
   * 应用实例的名称 */
  public String getAppServiceName() {
    return this.appServiceName;
  }

  /**
   * 应用实例的名称 */
  public void setAppServiceName(String appServiceName) {
    this.appServiceName = appServiceName;
  }

  /**
   * 创建人id搜索 */
  public List<String> getCreatorIds() {
    return this.creatorIds;
  }

  /**
   * 创建人id搜索 */
  public void setCreatorIds(List<String> creatorIds) {
    this.creatorIds = creatorIds;
  }

  /**
   * 版本号搜索 */
  public List<String> getFullVersions() {
    return this.fullVersions;
  }

  /**
   * 版本号搜索 */
  public void setFullVersions(List<String> fullVersions) {
    this.fullVersions = fullVersions;
  }

  /**
   * 排它 */
  public String getFullVersionLike() {
    return this.fullVersionLike;
  }

  /**
   * 排它 */
  public void setFullVersionLike(String fullVersionLike) {
    this.fullVersionLike = fullVersionLike;
  }

  /**
   * 查询的pageNo */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 查询的pageNo */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 查询的pagesize */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 查询的pagesize */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 流量百分比大于等于多少 */
  public Long getRouteWeightPercentFrom() {
    return this.routeWeightPercentFrom;
  }

  /**
   * 流量百分比大于等于多少 */
  public void setRouteWeightPercentFrom(Long routeWeightPercentFrom) {
    this.routeWeightPercentFrom = routeWeightPercentFrom;
  }

  /**
   * 流量百分比小于等于多少 */
  public Long getRouteWeightPercentTo() {
    return this.routeWeightPercentTo;
  }

  /**
   * 流量百分比小于等于多少 */
  public void setRouteWeightPercentTo(Long routeWeightPercentTo) {
    this.routeWeightPercentTo = routeWeightPercentTo;
  }

  /**
   * 运行时标识查询 */
  public List<String> getRuntimeIdentities() {
    return this.runtimeIdentities;
  }

  /**
   * 运行时标识查询 */
  public void setRuntimeIdentities(List<String> runtimeIdentities) {
    this.runtimeIdentities = runtimeIdentities;
  }

  /**
   * 是否是共享集群 如果是共享集群, 则需要填写cluster 默认为true */
  public Boolean getShared() {
    return this.shared;
  }

  /**
   * 是否是共享集群 如果是共享集群, 则需要填写cluster 默认为true */
  public void setShared(Boolean shared) {
    this.shared = shared;
  }

  /**
   * 按照使用的规格查询 */
  public List<String> getSpecIdentities() {
    return this.specIdentities;
  }

  /**
   * 按照使用的规格查询 */
  public void setSpecIdentities(List<String> specIdentities) {
    this.specIdentities = specIdentities;
  }

  /**
   * 环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
