//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.sas.v1_0_0.response.InitWorkspaceResponse;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 初始化workspace
 */
public class InitWorkspaceRequest extends AntCloudProviderRequest<InitWorkspaceResponse> {
  @NotNull
  private String identity;

  @NotNull
  private String name;

  private String networkType;

  @NotNull
  private String regionId;

  @NotNull
  private List<String> zoneIds;

  public InitWorkspaceRequest() {
    super("antcloud.sas.workspace.init", "1.0", "Java-SDK-20190410");
  }

  /**
   * 环境标识，环境的唯一标识，不可重复，以字母开头，只能包含字母和数字 */
  public String getIdentity() {
    return this.identity;
  }

  /**
   * 环境标识，环境的唯一标识，不可重复，以字母开头，只能包含字母和数字 */
  public void setIdentity(String identity) {
    this.identity = identity;
  }

  /**
   * 环境名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 环境名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 网络类型 */
  public String getNetworkType() {
    return this.networkType;
  }

  /**
   * 网络类型 */
  public void setNetworkType(String networkType) {
    this.networkType = networkType;
  }

  /**
   * 地域Id */
  public String getRegionId() {
    return this.regionId;
  }

  /**
   * 地域Id */
  public void setRegionId(String regionId) {
    this.regionId = regionId;
  }

  /**
   * 可用区Ids */
  public List<String> getZoneIds() {
    return this.zoneIds;
  }

  /**
   * 可用区Ids */
  public void setZoneIds(List<String> zoneIds) {
    this.zoneIds = zoneIds;
  }
}
