//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.model;

import java.lang.Long;
import java.lang.String;

/**
 * 规格基本信息
 * 包含了内存, CPU,磁盘信息 */
public class ServerlessSpec {
  private String cpu;

  private String description;

  private Long disk;

  private String identity;

  private Long memory;

  private String name;

  private String readableCpu;

  private String readableDisk;

  private String readableMemory;

  /**
   * CPU核数. 可以是小数 */
  public String getCpu() {
    return this.cpu;
  }

  /**
   * CPU核数. 可以是小数 */
  public void setCpu(String cpu) {
    this.cpu = cpu;
  }

  /**
   * 描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 磁盘大小 byte */
  public Long getDisk() {
    return this.disk;
  }

  /**
   * 磁盘大小 byte */
  public void setDisk(Long disk) {
    this.disk = disk;
  }

  /**
   * 规格标识 */
  public String getIdentity() {
    return this.identity;
  }

  /**
   * 规格标识 */
  public void setIdentity(String identity) {
    this.identity = identity;
  }

  /**
   * 内存大小，单位是byte */
  public Long getMemory() {
    return this.memory;
  }

  /**
   * 内存大小，单位是byte */
  public void setMemory(Long memory) {
    this.memory = memory;
  }

  /**
   * 规格名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 规格名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * cpu的可读化字符串表示 */
  public String getReadableCpu() {
    return this.readableCpu;
  }

  /**
   * cpu的可读化字符串表示 */
  public void setReadableCpu(String readableCpu) {
    this.readableCpu = readableCpu;
  }

  /**
   * 使用的磁盘可读化表示 */
  public String getReadableDisk() {
    return this.readableDisk;
  }

  /**
   * 使用的磁盘可读化表示 */
  public void setReadableDisk(String readableDisk) {
    this.readableDisk = readableDisk;
  }

  /**
   * 内存的可读化字符串表示 */
  public String getReadableMemory() {
    return this.readableMemory;
  }

  /**
   * 内存的可读化字符串表示 */
  public void setReadableMemory(String readableMemory) {
    this.readableMemory = readableMemory;
  }
}
