//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import java.util.Date;

/**
 * 应用实例详细信息 */
public class ServerlessAppServiceDetailInfo {
  private String appName;

  private CheckService checkService;

  private String cluster;

  private Date creationTime;

  private String creatorId;

  private String description;

  private String externalDomains;

  private String internalDomains;

  private LogConfig logConfig;

  private LogIndex logIndex;

  private String logProject;

  private String logStore;

  private String logTenant;

  private String maxAverageCpuUtilizationPercent;

  private String maxAverageMemUtilizationPercent;

  private String maxAverageQps;

  private Long maxComputeInstance;

  private Long maxConcurrentConnections;

  private Long maxResponseTimeInMs;

  private String minAverageCpuUtilizationPercent;

  private String minAverageMemUtilizationPercent;

  private String minAverageQps;

  private Long minConcurrentConnections;

  private Long minResponseTimeInMs;

  private String name;

  private Long reservedComputeInstance;

  private String techstackIdentity;

  private String techstackName;

  private String tenant;

  private Date updateTime;

  private String workspace;

  /**
   * 应用名称 */
  public String getAppName() {
    return this.appName;
  }

  /**
   * 应用名称 */
  public void setAppName(String appName) {
    this.appName = appName;
  }

  /**
   * 健康检查 */
  public CheckService getCheckService() {
    return this.checkService;
  }

  /**
   * 健康检查 */
  public void setCheckService(CheckService checkService) {
    this.checkService = checkService;
  }

  /**
   * 该版本所在的集群标识，可枚举：
   * 小程序上海非金区预发：miniapp-pre
   * 小程序上海非金区生产：miniapp-prod-shnf
   * 必填 */
  public String getCluster() {
    return this.cluster;
  }

  /**
   * 该版本所在的集群标识，可枚举：
   * 小程序上海非金区预发：miniapp-pre
   * 小程序上海非金区生产：miniapp-prod-shnf
   * 必填 */
  public void setCluster(String cluster) {
    this.cluster = cluster;
  }

  /**
   * 应用实例创建时间 */
  public Date getCreationTime() {
    return this.creationTime;
  }

  /**
   * 应用实例创建时间 */
  public void setCreationTime(Date creationTime) {
    this.creationTime = creationTime;
  }

  /**
   * 应用实例的创建人ID，即用户ID */
  public String getCreatorId() {
    return this.creatorId;
  }

  /**
   * 应用实例的创建人ID，即用户ID */
  public void setCreatorId(String creatorId) {
    this.creatorId = creatorId;
  }

  /**
   * 应用实例描述
   * 可以包含中英文字符 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 应用实例描述
   * 可以包含中英文字符 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * 选填，应用服务的公网域名，域名需自行额外注册，可修改，可选 */
  public String getExternalDomains() {
    return this.externalDomains;
  }

  /**
   * 选填，应用服务的公网域名，域名需自行额外注册，可修改，可选 */
  public void setExternalDomains(String externalDomains) {
    this.externalDomains = externalDomains;
  }

  /**
   * 选填，应用服务的内网域名，可供服务间调用，可修改，可选 */
  public String getInternalDomains() {
    return this.internalDomains;
  }

  /**
   * 选填，应用服务的内网域名，可供服务间调用，可修改，可选 */
  public void setInternalDomains(String internalDomains) {
    this.internalDomains = internalDomains;
  }

  /**
   * 日志配置 */
  public LogConfig getLogConfig() {
    return this.logConfig;
  }

  /**
   * 日志配置 */
  public void setLogConfig(LogConfig logConfig) {
    this.logConfig = logConfig;
  }

  /**
   * 索引配置 */
  public LogIndex getLogIndex() {
    return this.logIndex;
  }

  /**
   * 索引配置 */
  public void setLogIndex(LogIndex logIndex) {
    this.logIndex = logIndex;
  }

  /**
   * 日志项目名称 */
  public String getLogProject() {
    return this.logProject;
  }

  /**
   * 日志项目名称 */
  public void setLogProject(String logProject) {
    this.logProject = logProject;
  }

  /**
   * 日志库 */
  public String getLogStore() {
    return this.logStore;
  }

  /**
   * 日志库 */
  public void setLogStore(String logStore) {
    this.logStore = logStore;
  }

  /**
   * 日志对应的租户 */
  public String getLogTenant() {
    return this.logTenant;
  }

  /**
   * 日志对应的租户 */
  public void setLogTenant(String logTenant) {
    this.logTenant = logTenant;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public String getMaxAverageCpuUtilizationPercent() {
    return this.maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大CPU使用率，当平均CPU使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public void setMaxAverageCpuUtilizationPercent(String maxAverageCpuUtilizationPercent) {
    this.maxAverageCpuUtilizationPercent = maxAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此。
   * 上述8个指标类字段为null，则不会触发自动扩缩 */
  public String getMaxAverageMemUtilizationPercent() {
    return this.maxAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比。该版本平均所有计算实例最大内存使用率，当平均内存使用率大于该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此。
   * 上述8个指标类字段为null，则不会触发自动扩缩 */
  public void setMaxAverageMemUtilizationPercent(String maxAverageMemUtilizationPercent) {
    this.maxAverageMemUtilizationPercent = maxAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。平均每个实例可服务的最大QPS（Query Per Second，平均每秒请求数），超过该值会触发该服务版本的自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public String getMaxAverageQps() {
    return this.maxAverageQps;
  }

  /**
   * 实际为Double类型。平均每个实例可服务的最大QPS（Query Per Second，平均每秒请求数），超过该值会触发该服务版本的自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public void setMaxAverageQps(String maxAverageQps) {
    this.maxAverageQps = maxAverageQps;
  }

  /**
   * 最大计算实例. 当前服务实例所有版本扩容时计算实例数总和最大值.默认为500 */
  public Long getMaxComputeInstance() {
    return this.maxComputeInstance;
  }

  /**
   * 最大计算实例. 当前服务实例所有版本扩容时计算实例数总和最大值.默认为500 */
  public void setMaxComputeInstance(Long maxComputeInstance) {
    this.maxComputeInstance = maxComputeInstance;
  }

  /**
   * 平均每个计算实例可同时存在的并发连接数，精度到秒，超过该值会触发该服务版本的自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public Long getMaxConcurrentConnections() {
    return this.maxConcurrentConnections;
  }

  /**
   * 平均每个计算实例可同时存在的并发连接数，精度到秒，超过该值会触发该服务版本的自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public void setMaxConcurrentConnections(Long maxConcurrentConnections) {
    this.maxConcurrentConnections = maxConcurrentConnections;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public Long getMaxResponseTimeInMs() {
    return this.maxResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最大平均响应时间，当平均请求响应时间超过该值，会触发自动扩容，但不会超过 max_compute_instance 的设置，一般最多会在分钟级触发扩容，当流量激增可能会在更短时间内扩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public void setMaxResponseTimeInMs(Long maxResponseTimeInMs) {
    this.maxResponseTimeInMs = maxResponseTimeInMs;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public String getMinAverageCpuUtilizationPercent() {
    return this.minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小CPU使用率，当平均CPU使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public void setMinAverageCpuUtilizationPercent(String minAverageCpuUtilizationPercent) {
    this.minAverageCpuUtilizationPercent = minAverageCpuUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public String getMinAverageMemUtilizationPercent() {
    return this.minAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。百分比，如 0.1 表示 0.1%。该版本平均所有计算实例最小内存使用率，当平均内存使用率小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public void setMinAverageMemUtilizationPercent(String minAverageMemUtilizationPercent) {
    this.minAverageMemUtilizationPercent = minAverageMemUtilizationPercent;
  }

  /**
   * 实际为Double类型。平均每个实例可服务的最小QPS（Query Per Second，平均每秒请求数），小于该值会触发该服务版本的自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public String getMinAverageQps() {
    return this.minAverageQps;
  }

  /**
   * 实际为Double类型。平均每个实例可服务的最小QPS（Query Per Second，平均每秒请求数），小于该值会触发该服务版本的自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public void setMinAverageQps(String minAverageQps) {
    this.minAverageQps = minAverageQps;
  }

  /**
   * 平均每个计算实例可同时存在的并发连接数，精度到秒，小于该值会触发该服务版本的自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public Long getMinConcurrentConnections() {
    return this.minConcurrentConnections;
  }

  /**
   * 平均每个计算实例可同时存在的并发连接数，精度到秒，小于该值会触发该服务版本的自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板作用，新建应用服务版本不传会默认继承于此 */
  public void setMinConcurrentConnections(Long minConcurrentConnections) {
    this.minConcurrentConnections = minConcurrentConnections;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public Long getMinResponseTimeInMs() {
    return this.minResponseTimeInMs;
  }

  /**
   * 单位毫秒。该版本服务的请求可容忍的最小平均响应时间，当平均请求响应时间小于该值，会触发自动缩容，但不会少于 min_compute_instance 的设置，一般最多会在分钟级触发缩容。可修改，可选，模板效果，新建应用服务版本不传会默认继承于此 */
  public void setMinResponseTimeInMs(Long minResponseTimeInMs) {
    this.minResponseTimeInMs = minResponseTimeInMs;
  }

  /**
   * 应用实例名称
   * 默认是是应用的name */
  public String getName() {
    return this.name;
  }

  /**
   * 应用实例名称
   * 默认是是应用的name */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 保留计算实例个数.
   * 系统会为当前应用服务实例预留多少个计算实例空间提供服务。设置保留计算实例可以确保所有应用业务量较大时，始终保障当前应用服务实例可以使用特定数量的计算实例，但其它服务实例可用的总计算实例数会相应减少且扩容时不会占用预留空间 */
  public Long getReservedComputeInstance() {
    return this.reservedComputeInstance;
  }

  /**
   * 保留计算实例个数.
   * 系统会为当前应用服务实例预留多少个计算实例空间提供服务。设置保留计算实例可以确保所有应用业务量较大时，始终保障当前应用服务实例可以使用特定数量的计算实例，但其它服务实例可用的总计算实例数会相应减少且扩容时不会占用预留空间 */
  public void setReservedComputeInstance(Long reservedComputeInstance) {
    this.reservedComputeInstance = reservedComputeInstance;
  }

  /**
   * 应用实例使用的技术栈标识(冗余应用) */
  public String getTechstackIdentity() {
    return this.techstackIdentity;
  }

  /**
   * 应用实例使用的技术栈标识(冗余应用) */
  public void setTechstackIdentity(String techstackIdentity) {
    this.techstackIdentity = techstackIdentity;
  }

  /**
   * 应用实例使用的技术栈名称(冗余应用) */
  public String getTechstackName() {
    return this.techstackName;
  }

  /**
   * 应用实例使用的技术栈名称(冗余应用) */
  public void setTechstackName(String techstackName) {
    this.techstackName = techstackName;
  }

  /**
   * 该应用实例所属的租户名称 */
  public String getTenant() {
    return this.tenant;
  }

  /**
   * 该应用实例所属的租户名称 */
  public void setTenant(String tenant) {
    this.tenant = tenant;
  }

  /**
   * 应用实例修改时间 */
  public Date getUpdateTime() {
    return this.updateTime;
  }

  /**
   * 应用实例修改时间 */
  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }

  /**
   * 该应用实例所属的环境标识 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 该应用实例所属的环境标识 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
