//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.sas.v1_0_0.model;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;

/**
 * 日志设置 */
public class LogConfig {
  private String fileEncoding;

  private String filePattern;

  private List<String> filterKey;

  private List<String> filterRegex;

  private List<String> key;

  private Boolean localStorage;

  private String logBeginRegex;

  private String logPath;

  private String logType;

  private Boolean preserve;

  private Long preserveDepth;

  private String regex;

  private String sampleLog;

  private String timeFormat;

  private String topicFormat;

  /**
   * 默认 UTF-8
   * 可选值 UTF-8 */
  public String getFileEncoding() {
    return this.fileEncoding;
  }

  /**
   * 默认 UTF-8
   * 可选值 UTF-8 */
  public void setFileEncoding(String fileEncoding) {
    this.fileEncoding = fileEncoding;
  }

  /**
   * 文件通配符 */
  public String getFilePattern() {
    return this.filePattern;
  }

  /**
   * 文件通配符 */
  public void setFilePattern(String filePattern) {
    this.filePattern = filePattern;
  }

  /**
   * 用于过滤日志所用到的key，只有key的值满足对应filterRegex列中设定的正则表达式日志才是符合要求的 */
  public List<String> getFilterKey() {
    return this.filterKey;
  }

  /**
   * 用于过滤日志所用到的key，只有key的值满足对应filterRegex列中设定的正则表达式日志才是符合要求的 */
  public void setFilterKey(List<String> filterKey) {
    this.filterKey = filterKey;
  }

  /**
   * 和每个filterKey对应的正正则表达式， filterRegex的长度和filterKey的长度必须相同 */
  public List<String> getFilterRegex() {
    return this.filterRegex;
  }

  /**
   * 和每个filterKey对应的正正则表达式， filterRegex的长度和filterKey的长度必须相同 */
  public void setFilterRegex(List<String> filterRegex) {
    this.filterRegex = filterRegex;
  }

  /**
   * 日志提取后所生成Key */
  public List<String> getKey() {
    return this.key;
  }

  /**
   * 日志提取后所生成Key */
  public void setKey(List<String> key) {
    this.key = key;
  }

  /**
   * cache in local storage */
  public Boolean getLocalStorage() {
    return this.localStorage;
  }

  /**
   * cache in local storage */
  public void setLocalStorage(Boolean localStorage) {
    this.localStorage = localStorage;
  }

  /**
   * 多行日志行首匹配 */
  public String getLogBeginRegex() {
    return this.logBeginRegex;
  }

  /**
   * 多行日志行首匹配 */
  public void setLogBeginRegex(String logBeginRegex) {
    this.logBeginRegex = logBeginRegex;
  }

  /**
   * log目录 */
  public String getLogPath() {
    return this.logPath;
  }

  /**
   * log目录 */
  public void setLogPath(String logPath) {
    this.logPath = logPath;
  }

  /**
   * 目前只支持common_reg_log */
  public String getLogType() {
    return this.logType;
  }

  /**
   * 目前只支持common_reg_log */
  public void setLogType(String logType) {
    this.logType = logType;
  }

  /**
   * rue代表监控目录永不超时，false代表监控目录30分钟超时，默认值为true */
  public Boolean getPreserve() {
    return this.preserve;
  }

  /**
   * rue代表监控目录永不超时，false代表监控目录30分钟超时，默认值为true */
  public void setPreserve(Boolean preserve) {
    this.preserve = preserve;
  }

  /**
   * 当设置preserve为false时，指定监控不超时目录的深度，最大深度支持3 */
  public Long getPreserveDepth() {
    return this.preserveDepth;
  }

  /**
   * 当设置preserve为false时，指定监控不超时目录的深度，最大深度支持3 */
  public void setPreserveDepth(Long preserveDepth) {
    this.preserveDepth = preserveDepth;
  }

  /**
   * 正则匹配 */
  public String getRegex() {
    return this.regex;
  }

  /**
   * 正则匹配 */
  public void setRegex(String regex) {
    this.regex = regex;
  }

  /**
   * 示例日志 */
  public String getSampleLog() {
    return this.sampleLog;
  }

  /**
   * 示例日志 */
  public void setSampleLog(String sampleLog) {
    this.sampleLog = sampleLog;
  }

  /**
   * 日期格式 */
  public String getTimeFormat() {
    return this.timeFormat;
  }

  /**
   * 日期格式 */
  public void setTimeFormat(String timeFormat) {
    this.timeFormat = timeFormat;
  }

  /**
   * topic生成方式，支持四种类型：1）用于将日志文件路径的某部分作为topic，如/var/log/(.*).log；
   *     //2）none，表示topic为空；3）default，表示将日志文件路径作为topic；4）group_topic，表示将应用该配置的机器组topic属性作为topic。 */
  public String getTopicFormat() {
    return this.topicFormat;
  }

  /**
   * topic生成方式，支持四种类型：1）用于将日志文件路径的某部分作为topic，如/var/log/(.*).log；
   *     //2）none，表示topic为空；3）default，表示将日志文件路径作为topic；4）group_topic，表示将应用该配置的机器组topic属性作为topic。 */
  public void setTopicFormat(String topicFormat) {
    this.topicFormat = topicFormat;
  }
}
