/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.swagger.ext.core.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public abstract class ResourceScannerUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceScannerUtils.class);
    private static final String RESOURCE_PATTERN = "classpath*:**/%s/**/*.%s";

    private ResourceScannerUtils() {
    }

    public static Set<Class<?>> scanClass(String scanPackage) throws IOException, ClassNotFoundException {
        return ResourceScannerUtils.doScanClass(scanPackage, null);
    }

    public static Set<Class<?>> scanClassFromSuper(String scanPackage, Class<?>[] superClazzs) throws IOException, ClassNotFoundException {
        LinkedList<AssignableTypeFilter> typeFilters = new LinkedList<AssignableTypeFilter>();
        if (ArrayUtils.isNotEmpty((Object[])superClazzs)) {
            for (Class<?> superCls : superClazzs) {
                typeFilters.add(new AssignableTypeFilter(superCls));
            }
        }
        return ResourceScannerUtils.doScanClass(scanPackage, typeFilters);
    }

    public static Set<Class<?>> scanClassFromAnnotation(String scanPackage, Class<? extends Annotation>[] annotationTypes) throws IOException, ClassNotFoundException {
        return ResourceScannerUtils.scanClassFromAnnotation(scanPackage, annotationTypes, false);
    }

    public static Set<Class<?>> scanClassFromAnnotation(String scanPackage, Class<? extends Annotation>[] annotationTypes, boolean considerMetaAnnotations) throws IOException, ClassNotFoundException {
        LinkedList<AnnotationTypeFilter> typeFilters = new LinkedList<AnnotationTypeFilter>();
        if (ArrayUtils.isNotEmpty((Object[])annotationTypes)) {
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                typeFilters.add(new AnnotationTypeFilter(annotationType, considerMetaAnnotations));
            }
        }
        return ResourceScannerUtils.doScanClass(scanPackage, typeFilters);
    }

    private static Set<Class<?>> doScanClass(String scanPackage, List<? extends TypeFilter> typeFilters) throws IOException, ClassNotFoundException {
        HashSet foundClazzs = new HashSet();
        Set<Resource> resources = ResourceScannerUtils.scan(scanPackage, "class");
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        for (Resource resource : resources) {
            MetadataReader reader = readerFactory.getMetadataReader(resource);
            Class cls = ClassUtils.forName((String)reader.getClassMetadata().getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            if (CollectionUtils.isEmpty(typeFilters)) {
                foundClazzs.add(cls);
                continue;
            }
            for (TypeFilter typeFilter : typeFilters) {
                if (!typeFilter.match(reader, (MetadataReaderFactory)readerFactory)) continue;
                foundClazzs.add(cls);
            }
        }
        return foundClazzs;
    }

    public static Set<Resource> scan(String scanPackage, String suffix) throws IOException {
        String[] scanPackages;
        if (StringUtils.isBlank((CharSequence)scanPackage)) {
            throw new IllegalArgumentException("The scanPackage path is Null!");
        }
        suffix = (String)StringUtils.defaultIfEmpty((CharSequence)suffix, (CharSequence)"class");
        HashSet<Resource> foundResources = new HashSet<Resource>();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        for (String scanPack : scanPackages = scanPackage.split(",|;")) {
            Resource[] resources;
            for (Resource resource : resources = resourcePatternResolver.getResources(String.format(RESOURCE_PATTERN, ClassUtils.convertClassNameToResourcePath((String)scanPack), suffix))) {
                if (resource.isReadable()) {
                    foundResources.add(resource);
                    continue;
                }
                logger.warn("Resource [ {} ] unReadable!", (Object)resource.getFilename());
            }
        }
        return foundResources;
    }

    public static class SUFFIX {
        public static final String ALL = "*";
        public static final String XML = "xml";
        public static final String CLASS = "class";
    }
}

