/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.swagger.ext.core.operation.provider;

import cn.chenzw.swagger.ext.core.model.SwaggerModel;
import cn.chenzw.swagger.ext.core.model.SwaggerModelProperty;
import cn.chenzw.swagger.ext.core.util.SwaggerUtils;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import io.swagger.annotations.ext.ApiMapParam;
import io.swagger.annotations.ext.ApiMapParams;
import io.swagger.annotations.ext.ApiMapResponse;
import io.swagger.annotations.ext.ApiMapResponses;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

@Component
@Order(value=-2147483648)
public class SwaggerMapModelsProvider
implements OperationModelsProviderPlugin {
    private TypeResolver typeResolver;
    private TypeNameExtractor nameExtractor;

    public SwaggerMapModelsProvider(TypeResolver typeResolver, TypeNameExtractor nameExtractor) {
        this.typeResolver = typeResolver;
        this.nameExtractor = nameExtractor;
    }

    public void apply(RequestMappingContext context) {
        List apiMapParamsList = context.findAnnotations(ApiMapParams.class);
        for (Object apiMapParams : apiMapParamsList) {
            this.createParamterModel(context, (ApiMapParams)apiMapParams);
        }
        List parameters = context.getParameters();
        for (ResolvedMethodParameter parameter : parameters) {
            Optional apiMapParamsMethodOptional = parameter.findAnnotation(ApiMapParams.class);
            if (!apiMapParamsMethodOptional.isPresent()) continue;
            this.createParamterModel(context, (ApiMapParams)apiMapParamsMethodOptional.get());
        }
        Optional apiMapResponsesOptional = context.findAnnotation(ApiMapResponses.class);
        if (apiMapResponsesOptional.isPresent()) {
            this.createResponseModel(context, (ApiMapResponses)apiMapResponsesOptional.get());
        }
    }

    public boolean supports(DocumentationType documentationType) {
        return true;
    }

    private void createParamterModel(RequestMappingContext context, ApiMapParams apiMapParams) {
        HashMap<String, SwaggerModelProperty> properties = new HashMap<String, SwaggerModelProperty>();
        for (ApiMapParam apiMapParam : apiMapParams.value()) {
            properties.put(apiMapParam.key(), new SwaggerModelProperty(apiMapParam.key(), apiMapParam.example(), apiMapParam.description(), apiMapParam.defaultValue(), apiMapParam.required(), apiMapParam.allowableValues(), apiMapParam.access(), apiMapParam.allowMultiple(), apiMapParam.dataTypeClass(), apiMapParam.paramType(), apiMapParam.format(), apiMapParam.readOnly(), apiMapParam.collectionFormat()));
        }
        Class refModel = this.createRefModel(new SwaggerModel(apiMapParams.name(), SwaggerUtils.generateUniqueModelName(apiMapParams.name(), this.getRequestUri(context)), properties));
        if (refModel == null) {
            return;
        }
        context.getDocumentationContext().getAdditionalModels().add(this.typeResolver.resolve((Type)refModel, new Type[0]));
    }

    private void createResponseModel(RequestMappingContext context, ApiMapResponses apiMapResponses) {
        ApiMapResponse[] apiMapResponseList;
        HashMap<String, SwaggerModelProperty> properties = new HashMap<String, SwaggerModelProperty>();
        for (ApiMapResponse apiMapResponse : apiMapResponseList = apiMapResponses.value()) {
            properties.put(apiMapResponse.key(), new SwaggerModelProperty(apiMapResponse.key(), apiMapResponse.example(), apiMapResponse.description(), apiMapResponse.defaultValue(), apiMapResponse.required(), apiMapResponse.allowableValues(), apiMapResponse.access(), apiMapResponse.allowMultiple(), apiMapResponse.dataTypeClass(), apiMapResponse.paramType(), apiMapResponse.format(), apiMapResponse.readOnly(), apiMapResponse.collectionFormat()));
        }
        Class refModel = this.createRefModel(new SwaggerModel("response", SwaggerUtils.generateUniqueModelName("response", this.getRequestUri(context)), properties));
        if (refModel == null) {
            return;
        }
        context.getDocumentationContext().getAdditionalModels().add(this.typeResolver.resolve((Type)refModel, new Type[0]));
    }

    private Class createRefModel(SwaggerModel swaggerModel) {
        ClassPool classPool = ClassPool.getDefault();
        CtClass ctClass = classPool.makeClass("cn.chenzw.swagger.ext.model." + swaggerModel.getTypeName());
        try {
            Map<String, SwaggerModelProperty> properties = swaggerModel.getProperties();
            for (Map.Entry<String, SwaggerModelProperty> modelPropertyEntry : properties.entrySet()) {
                ctClass.addField(this.createField(modelPropertyEntry.getValue(), ctClass));
            }
            return ctClass.toClass();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private CtField createField(SwaggerModelProperty modelProperty, CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtField ctField = new CtField(ClassPool.getDefault().get(modelProperty.getDataTypeClass().getName()), modelProperty.getName(), ctClass);
        ctField.setModifiers(1);
        ConstPool constPool = ctClass.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation("io.swagger.annotations.ApiModelProperty", constPool);
        annotation.addMemberValue("value", (MemberValue)new StringMemberValue(modelProperty.getDescription(), constPool));
        annotation.addMemberValue("example", (MemberValue)new StringMemberValue(modelProperty.getExample(), constPool));
        annotation.addMemberValue("defaultValue", (MemberValue)new StringMemberValue(modelProperty.getDefaultValue(), constPool));
        annotation.addMemberValue("required", (MemberValue)new BooleanMemberValue(modelProperty.isRequired(), constPool));
        annotation.addMemberValue("allowableValues", (MemberValue)new StringMemberValue(modelProperty.getAllowableValues(), constPool));
        annotation.addMemberValue("allowMultiple", (MemberValue)new BooleanMemberValue(modelProperty.isAllowMultiple(), constPool));
        annotation.addMemberValue("readOnly", (MemberValue)new BooleanMemberValue(modelProperty.isReadOnly(), constPool));
        annotation.addMemberValue("format", (MemberValue)new StringMemberValue(modelProperty.getFormat(), constPool));
        annotation.addMemberValue("collectionFormat", (MemberValue)new StringMemberValue(modelProperty.getCollectionFormat(), constPool));
        annotation.addMemberValue("paramType", (MemberValue)new StringMemberValue(modelProperty.getParamType(), constPool));
        annotation.addMemberValue("dataTypeClass", (MemberValue)new ClassMemberValue(modelProperty.getDataTypeClass().getName(), constPool));
        attr.addAnnotation(annotation);
        ctField.getFieldInfo().addAttribute((AttributeInfo)attr);
        return ctField;
    }

    private String getRequestUri(RequestMappingContext context) {
        Set patterns = context.getPatternsCondition().getPatterns();
        Iterator iterator = patterns.iterator();
        if (iterator.hasNext()) {
            String pattern = (String)iterator.next();
            return pattern;
        }
        return "";
    }
}

