/*
 * Decompiled with CFR 0.152.
 */
package cn.chenzw.swagger.ext.core.predicate;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import springfox.documentation.RequestHandler;

public class ClassNamesPredicate
implements Predicate<RequestHandler> {
    private String[] classNames;

    public ClassNamesPredicate(String classNames) {
        this.classNames = classNames.split(",|;");
    }

    public ClassNamesPredicate(Set<String> classNameSets) {
        this.classNames = classNameSets.toArray(new String[classNameSets.size()]);
    }

    public boolean apply(RequestHandler input) {
        return (Boolean)this.declaringClass(input).transform(this.handlerClassName()).or((Object)true);
    }

    private Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.fromNullable((Object)input.declaringClass());
    }

    private Function<Class<?>, Boolean> handlerClassName() {
        return input -> ArrayUtils.contains((Object[])this.classNames, (Object)input.getCanonicalName());
    }
}

