/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.swipebacklayout;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.DrawableRes;
import androidx.core.view.ViewCompat;
import cn.bingoogolapple.swipebacklayout.BGASwipeBackLayout;
import cn.bingoogolapple.swipebacklayout.BGASwipeBackManager;
import cn.bingoogolapple.swipebacklayout.R;
import cn.bingoogolapple.swipebacklayout.UIUtil;
import java.lang.ref.WeakReference;

class BGASwipeBackShadowView
extends FrameLayout {
    private static final String TAG = BGASwipeBackShadowView.class.getSimpleName();
    private static final float WE_CHAT_STYLE_MAX_OFFSET = 0.75f;
    private Activity mActivity;
    private WeakReference<Activity> mPreActivity;
    private ViewGroup mPreDecorView;
    private View mPreContentView;
    private ImageView mPreImageView;
    private View mShadowView;
    private boolean mIsNeedShowShadow = true;
    private int mShadowResId = R.drawable.bga_sbl_shadow;
    private boolean mIsShadowAlphaGradient = true;
    private boolean mIsWeChatStyle = true;
    private boolean mIsCurrentActivityTranslucent;

    BGASwipeBackShadowView(Activity activity) {
        super((Context)activity);
        this.mActivity = activity;
        TypedArray typedArray = this.mActivity.getTheme().obtainStyledAttributes(new int[]{16842840});
        this.mIsCurrentActivityTranslucent = typedArray.getBoolean(0, false);
        typedArray.recycle();
    }

    void setIsNeedShowShadow(boolean isNeedShowShadow) {
        this.mIsNeedShowShadow = isNeedShowShadow;
        this.updateShadow();
    }

    void setShadowResId(@DrawableRes int shadowResId) {
        this.mShadowResId = shadowResId;
        this.updateShadow();
    }

    void setIsShadowAlphaGradient(boolean isShadowAlphaGradient) {
        this.mIsShadowAlphaGradient = isShadowAlphaGradient;
    }

    void setIsWeChatStyle(boolean isWeChatStyle) {
        this.mIsWeChatStyle = isWeChatStyle;
    }

    private void updateShadow() {
        if (this.mIsCurrentActivityTranslucent) {
            if (this.mIsNeedShowShadow) {
                this.setBackgroundResource(this.mShadowResId);
            } else {
                this.setBackgroundResource(17170445);
            }
        } else if (this.mIsNeedShowShadow) {
            if (this.mShadowView == null) {
                this.mShadowView = new View(this.getContext());
                this.addView(this.mShadowView, this.getChildCount(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
            this.mShadowView.setBackgroundResource(this.mShadowResId);
        } else if (this.mShadowView != null) {
            this.removeView(this.mShadowView);
        }
    }

    void bindPreActivity() {
        Activity preActivity;
        if (this.mIsCurrentActivityTranslucent) {
            return;
        }
        if (this.mPreActivity == null && (preActivity = BGASwipeBackManager.getInstance().getPenultimateActivity(this.mActivity)) != null) {
            this.mPreActivity = new WeakReference<Activity>(preActivity);
            this.mPreDecorView = (ViewGroup)preActivity.getWindow().getDecorView();
            this.mPreContentView = this.mPreDecorView.getChildAt(0);
            this.mPreDecorView.removeView(this.mPreContentView);
            this.addView(this.mPreContentView, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
    }

    void unBindPreActivity(boolean isNeedAddImageView) {
        if (this.mIsCurrentActivityTranslucent) {
            return;
        }
        if (this.mPreActivity == null) {
            return;
        }
        Activity activity = (Activity)this.mPreActivity.get();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        if (this.mPreDecorView != null && this.mPreContentView != null) {
            if (isNeedAddImageView && this.mPreImageView == null && this.containsProblemView((ViewGroup)this.mPreContentView)) {
                this.mPreImageView = new ImageView((Context)this.mActivity);
                this.mPreImageView.setScaleType(ImageView.ScaleType.FIT_XY);
                this.mPreImageView.setImageBitmap(this.getBitmap(this.mPreContentView));
                this.addView((View)this.mPreImageView, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
            this.removeView(this.mPreContentView);
            FrameLayout.LayoutParams lp = null;
            if (!(this.mPreContentView instanceof BGASwipeBackLayout)) {
                int width = this.mPreDecorView.getWidth();
                int height = this.mPreDecorView.getHeight() - UIUtil.getNavigationBarHeight(activity);
                if (!UIUtil.isPortrait(activity)) {
                    width = this.mPreDecorView.getWidth() - UIUtil.getNavigationBarHeight(activity);
                    height = this.mPreDecorView.getHeight();
                }
                if (this.mPreDecorView instanceof FrameLayout) {
                    lp = new FrameLayout.LayoutParams(width, height);
                } else if (this.mPreDecorView instanceof LinearLayout) {
                    lp = new LinearLayout.LayoutParams(width, height);
                } else if (this.mPreDecorView instanceof RelativeLayout) {
                    lp = new RelativeLayout.LayoutParams(width, height);
                }
            }
            if (lp == null) {
                this.mPreDecorView.addView(this.mPreContentView, 0);
            } else {
                this.mPreDecorView.addView(this.mPreContentView, 0, lp);
            }
            this.mPreContentView = null;
            this.mPreActivity.clear();
            this.mPreActivity = null;
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mIsCurrentActivityTranslucent) {
            return;
        }
        if (this.mPreImageView != null) {
            return;
        }
        if (this.mPreContentView == null && this.mPreDecorView != null) {
            this.mPreDecorView.draw(canvas);
        }
    }

    private Bitmap getBitmap(View view) {
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache(), (int)0, (int)0, (int)UIUtil.getRealScreenWidth(this.mActivity), (int)(UIUtil.getRealScreenHeight(this.mActivity) - UIUtil.getNavigationBarHeight(this.mActivity)));
        view.destroyDrawingCache();
        return bitmap;
    }

    private boolean containsProblemView(ViewGroup viewGroup) {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = viewGroup.getChildAt(i);
            if (BGASwipeBackManager.getInstance().isProblemView(childView)) {
                return true;
            }
            if (!(childView instanceof ViewGroup) || !this.containsProblemView((ViewGroup)childView)) continue;
            return true;
        }
        return false;
    }

    void setShadowAlpha(float alpha) {
        if (this.mIsNeedShowShadow && this.mIsShadowAlphaGradient) {
            if (this.mIsCurrentActivityTranslucent) {
                ViewCompat.setAlpha((View)this, (float)alpha);
            } else if (this.mShadowView != null) {
                ViewCompat.setAlpha((View)this.mShadowView, (float)alpha);
            }
        }
    }

    void onPanelSlide(float slideOffset) {
        if (this.mIsWeChatStyle) {
            if (this.mIsCurrentActivityTranslucent) {
                this.onPanelSlide(this.mActivity, slideOffset);
            } else if (this.mPreContentView != null) {
                ViewCompat.setTranslationX((View)this.mPreContentView, (float)((float)this.mPreContentView.getMeasuredWidth() * 0.75f * (1.0f - slideOffset)));
            }
        } else if (!this.mIsCurrentActivityTranslucent && this.mPreContentView != null) {
            ViewCompat.setTranslationX((View)this.mPreContentView, (float)((float)this.mPreContentView.getMeasuredWidth() * (1.0f - slideOffset)));
        }
    }

    private void onPanelSlide(Activity currentActivity, float slideOffset) {
        try {
            Activity preActivity = BGASwipeBackManager.getInstance().getPenultimateActivity(currentActivity);
            if (preActivity != null) {
                View decorView = preActivity.getWindow().getDecorView();
                ViewCompat.setTranslationX((View)decorView, (float)((float)(-decorView.getMeasuredWidth()) * 0.25f * (1.0f - slideOffset)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onPanelClosed() {
        if (this.mIsWeChatStyle) {
            if (this.mIsCurrentActivityTranslucent) {
                this.onPanelClosed(this.mActivity);
            } else if (this.mPreContentView != null) {
                ViewCompat.setTranslationX((View)this.mPreContentView, (float)0.0f);
            }
        } else if (!this.mIsCurrentActivityTranslucent && this.mPreContentView != null) {
            ViewCompat.setTranslationX((View)this.mPreContentView, (float)0.0f);
        }
        this.unBindPreActivity(false);
    }

    private void onPanelClosed(Activity currentActivity) {
        try {
            Activity preActivity = BGASwipeBackManager.getInstance().getPenultimateActivity(currentActivity);
            if (preActivity != null) {
                View decorView = preActivity.getWindow().getDecorView();
                ViewCompat.setTranslationX((View)decorView, (float)0.0f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

