/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.swipebacklayout;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

class BGASwipeBackManager
implements Application.ActivityLifecycleCallbacks {
    private static final BGASwipeBackManager sInstance = new BGASwipeBackManager();
    private Stack<Activity> mActivityStack = new Stack();
    private Set<Class<? extends View>> mProblemViewClassSet = new HashSet<Class<? extends View>>();

    public static BGASwipeBackManager getInstance() {
        return sInstance;
    }

    private BGASwipeBackManager() {
    }

    public void init(Application application, List<Class<? extends View>> problemViewClassList) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.mProblemViewClassSet.add(WebView.class);
        this.mProblemViewClassSet.add(SurfaceView.class);
        if (problemViewClassList != null) {
            this.mProblemViewClassSet.addAll(problemViewClassList);
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.mActivityStack.add(activity);
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mActivityStack.remove(activity);
    }

    @Nullable
    public Activity getPenultimateActivity(Activity currentActivity) {
        Activity activity = null;
        try {
            if (this.mActivityStack.size() > 1 && currentActivity.equals(activity = (Activity)this.mActivityStack.get(this.mActivityStack.size() - 2))) {
                int index = this.mActivityStack.indexOf(currentActivity);
                if (index > 0) {
                    activity = (Activity)this.mActivityStack.get(index - 1);
                } else if (this.mActivityStack.size() == 2) {
                    activity = (Activity)this.mActivityStack.lastElement();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activity;
    }

    public boolean isSwipeBackEnable() {
        return this.mActivityStack.size() > 1;
    }

    public boolean isProblemView(View view) {
        return this.mProblemViewClassSet.contains(view.getClass());
    }
}

