/*
 * Decompiled with CFR 0.152.
 */
package cn.appsdream.nestrefresh.normalstyle;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import cn.appsdream.nestrefresh.base.AbsRefreshLayout;
import com.github.anzewei.pagelist.R;

public class NestRefreshLayout
extends AbsRefreshLayout {
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            NestRefreshLayout.super.invokeRefresh();
        }
    };

    public NestRefreshLayout(Context context) {
        this(context, null);
    }

    public NestRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.nestRefreshLayoutStyle);
    }

    public NestRefreshLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    public NestRefreshLayout(View listView) {
        super(listView);
        this.init(listView.getContext(), null, R.attr.nestRefreshLayoutStyle);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.NestRefreshLayout, defStyleAttr, 0);
        int N = a.getIndexCount();
        int resHeader = R.layout.layout_refresh;
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 != R.styleable.NestRefreshLayout_headerNestLayout) continue;
            resHeader = a.getResourceId(attr2, resHeader);
        }
        a.recycle();
        this.setHeaderView(NestRefreshLayout.inflate((Context)context, (int)resHeader, null));
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (t < 0 && !this.isRefreshing() && this.isRefreshEnable()) {
            ((AbsRefreshLayout.LoaderDecor)this.mHeaderView).scrollRate(this.getOffsetY());
            if (this.getScrollY() < -this.mHeaderView.getMeasuredHeight()) {
                ((AbsRefreshLayout.LoaderDecor)this.mHeaderView).setState(1);
            } else {
                ((AbsRefreshLayout.LoaderDecor)this.mHeaderView).setState(0);
            }
        }
    }

    @Override
    protected void touchUp(MotionEvent event) {
        if (this.getScrollY() < -this.mHeaderView.getMeasuredHeight()) {
            this.invokeRefresh();
        } else {
            super.touchUp(event);
        }
    }

    @Override
    protected void invokeRefresh() {
        ((AbsRefreshLayout.LoaderDecor)this.mHeaderView).setState(2);
        this.animation2Header();
    }

    private void animation2Header() {
        this.setRefreshing(true);
        this.removeCallbacks(this.runnable);
        this.postDelayed(this.runnable, this.animation2Y(-this.mHeaderView.getMeasuredHeight()));
    }
}

