/*
 * Decompiled with CFR 0.152.
 */
package cn.appsdream.nestrefresh.matetialstyle;

import android.content.Context;
import android.content.res.Resources;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import cn.appsdream.nestrefresh.matetialstyle.MaterialProgressDrawable;
import cn.appsdream.nestrefresh.util.DisplayUtil;

public class ProgressAnimationImageView
extends ImageView {
    private MaterialProgressDrawable mProgress = new MaterialProgressDrawable(this.getContext(), (View)this);
    private Animation.AnimationListener mListener;

    public ProgressAnimationImageView(Context context) {
        super(context);
        if (DisplayUtil.isOver600dp(this.getContext())) {
            this.mProgress.updateSizes(0);
        }
        this.initialize();
    }

    private void initialize() {
        this.setImageDrawable(null);
        this.mProgress.setBackgroundColor(0);
        this.setImageDrawable(this.mProgress);
    }

    public void makeProgressTransparent() {
        this.mProgress.setAlpha(255);
    }

    public void showArrow(boolean show) {
        this.mProgress.showArrow(show);
    }

    public void setArrowScale(float scale) {
        this.mProgress.setArrowScale(scale);
    }

    public void setProgressAlpha(int alpha) {
        this.mProgress.setAlpha(alpha);
    }

    public void setProgressStartEndTrim(float startAngle, float endAngle) {
        this.mProgress.setStartEndTrim(startAngle, endAngle);
    }

    public void setProgressRotation(float rotation) {
        this.mProgress.setProgressRotation(rotation);
    }

    public void startProgress() {
        this.mProgress.start();
    }

    public void stopProgress() {
        this.mProgress.stop();
    }

    public void setProgressColorSchemeColors(int ... colors) {
        this.mProgress.setColorSchemeColors(colors);
    }

    public void setProgressColorSchemeColorsFromResource(int ... resources) {
        Resources res = this.getResources();
        int[] colorRes = new int[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            colorRes[i] = res.getColor(resources[i]);
        }
        this.setProgressColorSchemeColors(colorRes);
    }

    public void scaleWithKeepingAspectRatio(float scale) {
        ViewCompat.setScaleX((View)this, (float)scale);
        ViewCompat.setScaleY((View)this, (float)scale);
    }

    public void setAnimationListener(Animation.AnimationListener listener) {
        this.mListener = listener;
    }

    public void onAnimationStart() {
        super.onAnimationStart();
        if (this.mListener != null) {
            this.mListener.onAnimationStart(this.getAnimation());
        }
    }

    public void onAnimationEnd() {
        super.onAnimationEnd();
        if (this.mListener != null) {
            this.mListener.onAnimationEnd(this.getAnimation());
        }
    }
}

