/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.widget.curved;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.aigestudio.wheelpicker.R;
import com.aigestudio.wheelpicker.core.AbstractWheelDecor;
import com.aigestudio.wheelpicker.core.AbstractWheelPicker;
import com.aigestudio.wheelpicker.core.IWheelPicker;
import com.aigestudio.wheelpicker.view.WheelCrossPicker;
import com.aigestudio.wheelpicker.widget.IDigital;
import com.aigestudio.wheelpicker.widget.curved.WheelHourPicker;
import com.aigestudio.wheelpicker.widget.curved.WheelMinutePicker;
import java.util.List;

public class WheelTimePicker
extends LinearLayout
implements IWheelPicker,
IDigital {
    protected WheelHourPicker pickerHour;
    protected WheelMinutePicker pickerMinute;
    protected AbstractWheelPicker.OnWheelChangeListener listener;
    protected String hour;
    protected String minute;
    protected int labelColor = -16777216;
    protected int stateHour;
    protected int stateMinute;
    protected float labelTextSize;

    public WheelTimePicker(Context context) {
        super(context);
        this.init();
    }

    public WheelTimePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setGravity(17);
        this.setOrientation(0);
        int padding = this.getResources().getDimensionPixelSize(R.dimen.WheelPadding);
        int padding2x = padding * 2;
        this.labelTextSize = padding;
        LinearLayout.LayoutParams llParams = new LinearLayout.LayoutParams(-2, -2);
        this.pickerHour = new WheelHourPicker(this.getContext());
        this.pickerMinute = new WheelMinutePicker(this.getContext());
        this.pickerHour.setPadding(0, padding, padding2x, padding);
        this.pickerMinute.setPadding(0, padding, padding2x, padding);
        this.addLabel(this.pickerHour, "\u65f6");
        this.addLabel(this.pickerMinute, "\u5206");
        this.addView(this.pickerHour, (ViewGroup.LayoutParams)llParams);
        this.addView(this.pickerMinute, (ViewGroup.LayoutParams)llParams);
        this.initListener(this.pickerHour, 0);
        this.initListener(this.pickerMinute, 1);
    }

    private void addLabel(WheelCrossPicker picker, final String label) {
        picker.setWheelDecor(true, new AbstractWheelDecor(){

            @Override
            public void drawDecor(Canvas canvas, Rect rectLast, Rect rectNext, Paint paint) {
                paint.setColor(WheelTimePicker.this.labelColor);
                paint.setTextAlign(Paint.Align.CENTER);
                paint.setTextSize(WheelTimePicker.this.labelTextSize * 1.5f);
                canvas.drawText(label, (float)rectNext.centerX(), (float)rectNext.centerY() - (paint.ascent() + paint.descent()) / 2.0f, paint);
            }
        });
    }

    private void initListener(WheelCrossPicker picker, final int type) {
        picker.setOnWheelChangeListener(new AbstractWheelPicker.OnWheelChangeListener(){

            @Override
            public void onWheelScrolling(float deltaX, float deltaY) {
                if (null != WheelTimePicker.this.listener) {
                    WheelTimePicker.this.listener.onWheelScrolling(deltaX, deltaY);
                }
            }

            @Override
            public void onWheelSelected(int index, String data) {
                if (type == 0) {
                    WheelTimePicker.this.hour = data;
                }
                if (type == 1) {
                    WheelTimePicker.this.minute = data;
                }
                if (WheelTimePicker.this.isValidDate() && null != WheelTimePicker.this.listener) {
                    WheelTimePicker.this.listener.onWheelSelected(-1, WheelTimePicker.this.hour + ":" + WheelTimePicker.this.minute);
                }
            }

            @Override
            public void onWheelScrollStateChanged(int state) {
                if (type == 0) {
                    WheelTimePicker.this.stateHour = state;
                }
                if (type == 1) {
                    WheelTimePicker.this.stateMinute = state;
                }
                if (null != WheelTimePicker.this.listener) {
                    WheelTimePicker.this.checkState(WheelTimePicker.this.listener);
                }
            }
        });
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
        this.invalidate();
    }

    public void setLabelTextSize(float labelTextSize) {
        this.labelTextSize = labelTextSize;
        this.invalidate();
    }

    @Override
    public void setData(List<String> data) {
        throw new RuntimeException("Set data will not allow here!");
    }

    public void setCurrentTime(int hour, int minute) {
        this.pickerHour.setCurrentHour(hour);
        this.pickerMinute.setCurrentMinute(minute);
    }

    @Override
    public void setOnWheelChangeListener(AbstractWheelPicker.OnWheelChangeListener listener) {
        this.listener = listener;
    }

    private void checkState(AbstractWheelPicker.OnWheelChangeListener listener) {
        if (this.stateHour == 0 && this.stateMinute == 0) {
            listener.onWheelScrollStateChanged(0);
        }
        if (this.stateHour == 2 || this.stateMinute == 2) {
            listener.onWheelScrollStateChanged(2);
        }
        if (this.stateHour + this.stateMinute == 1) {
            listener.onWheelScrollStateChanged(1);
        }
    }

    private boolean isValidDate() {
        return !TextUtils.isEmpty((CharSequence)this.hour) && !TextUtils.isEmpty((CharSequence)this.minute);
    }

    @Override
    public void setItemIndex(int index) {
        this.pickerHour.setItemIndex(index);
        this.pickerMinute.setItemIndex(index);
    }

    @Override
    public void setItemSpace(int space) {
        this.pickerHour.setItemSpace(space);
        this.pickerMinute.setItemSpace(space);
    }

    @Override
    public void setItemCount(int count) {
        this.pickerHour.setItemCount(count);
        this.pickerMinute.setItemCount(count);
    }

    @Override
    public void setTextColor(int color) {
        this.pickerHour.setTextColor(color);
        this.pickerMinute.setTextColor(color);
    }

    @Override
    public void setTextSize(int size) {
        this.pickerHour.setTextSize(size);
        this.pickerMinute.setTextSize(size);
    }

    @Override
    public void clearCache() {
        this.pickerHour.clearCache();
        this.pickerMinute.clearCache();
    }

    @Override
    public void setCurrentTextColor(int color) {
        this.pickerHour.setCurrentTextColor(color);
        this.pickerMinute.setCurrentTextColor(color);
    }

    @Override
    public void setWheelDecor(boolean ignorePadding, AbstractWheelDecor decor) {
        this.pickerHour.setWheelDecor(ignorePadding, decor);
        this.pickerMinute.setWheelDecor(ignorePadding, decor);
    }

    @Override
    public void setDigitType(int type) {
        this.pickerHour.setDigitType(type);
        this.pickerMinute.setDigitType(type);
    }
}

