/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.widget.curved;

import android.content.Context;
import android.util.AttributeSet;
import com.aigestudio.wheelpicker.view.WheelCurvedPicker;
import com.aigestudio.wheelpicker.widget.IDigital;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class WheelHourPicker
extends WheelCurvedPicker
implements IDigital {
    private static final List<String> HOURS_DIGITAL_SINGLE;
    private static final List<String> HOURS_DIGITAL_DOUBLE;
    private List<String> hours = HOURS_DIGITAL_SINGLE;
    private int hour;

    public WheelHourPicker(Context context) {
        super(context);
        this.init();
    }

    public WheelHourPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        super.setData(this.hours);
        this.setCurrentHour(Calendar.getInstance().get(11));
    }

    @Override
    public void setData(List<String> data) {
        throw new RuntimeException("Set data will not allow here!");
    }

    public void setCurrentHour(int hour) {
        hour = Math.max(hour, 0);
        this.hour = hour = Math.min(hour, 23);
        this.setItemIndex(hour);
    }

    @Override
    public void setDigitType(int type) {
        this.hours = type == 1 ? HOURS_DIGITAL_SINGLE : HOURS_DIGITAL_DOUBLE;
        super.setData(this.hours);
    }

    static {
        int i;
        HOURS_DIGITAL_SINGLE = new ArrayList<String>();
        HOURS_DIGITAL_DOUBLE = new ArrayList<String>();
        for (i = 0; i < 24; ++i) {
            HOURS_DIGITAL_SINGLE.add(String.valueOf(i));
        }
        for (i = 0; i < 24; ++i) {
            String num = String.valueOf(i);
            if (num.length() == 1) {
                num = "0" + num;
            }
            HOURS_DIGITAL_DOUBLE.add(num);
        }
    }
}

