/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.view;

import android.content.Context;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Region;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.aigestudio.wheelpicker.view.WheelCrossPicker;
import java.util.HashMap;

public class WheelCurvedPicker
extends WheelCrossPicker {
    private final HashMap<Integer, Integer> SPACE = new HashMap();
    private final HashMap<Integer, Integer> DEPTH = new HashMap();
    private final Camera camera = new Camera();
    private final Matrix matrixRotate = new Matrix();
    private final Matrix matrixDepth = new Matrix();
    private int radius;
    private int degreeSingleDelta;
    private int degreeIndex;
    private int degreeUnitDelta;

    public WheelCurvedPicker(Context context) {
        super(context);
    }

    public WheelCurvedPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void computeWheelSizes() {
        super.computeWheelSizes();
        this.radius = this.mOrientation.computeRadius(this.itemCount, this.itemSpace, this.maxTextWidth, this.maxTextHeight);
        this.unit = (int)(180.0f / (float)(this.itemCount + 1));
        this.wheelContentWidth = this.mOrientation.getCurvedWidth(this.radius, this.maxTextWidth, this.maxTextHeight);
        this.wheelContentHeight = this.mOrientation.getCurvedHeight(this.radius, this.maxTextWidth, this.maxTextHeight);
        this.unitDisplayMin = -90;
        this.unitDisplayMax = 90;
        this.unitDeltaMin = -this.unit * (this.data.size() - this.itemIndex - 1);
        this.unitDeltaMax = this.unit * this.itemIndex;
    }

    @Override
    protected void drawItems(Canvas canvas) {
        for (int i = -this.itemIndex; i < this.data.size() - this.itemIndex; ++i) {
            int curUnit = this.unit * i;
            if ((curUnit += this.unitDeltaTotal + this.degreeSingleDelta) > this.unitDisplayMax || curUnit < this.unitDisplayMin) continue;
            int space = this.computeSpace(curUnit);
            if (space == 0) {
                curUnit = 1;
            }
            int depth = this.computeDepth(curUnit);
            this.camera.save();
            this.mOrientation.rotateCamera(this.camera, curUnit);
            this.camera.getMatrix(this.matrixRotate);
            this.camera.restore();
            this.mOrientation.matrixToCenter(this.matrixRotate, space, this.wheelCenterX, this.wheelCenterY);
            this.camera.save();
            this.camera.translate(0.0f, 0.0f, (float)depth);
            this.camera.getMatrix(this.matrixDepth);
            this.camera.restore();
            this.mOrientation.matrixToCenter(this.matrixDepth, space, this.wheelCenterX, this.wheelCenterY);
            this.matrixRotate.postConcat(this.matrixDepth);
            canvas.save();
            canvas.concat(this.matrixRotate);
            canvas.clipRect(this.rectCurItem, Region.Op.DIFFERENCE);
            this.mTextPaint.setColor(this.textColor);
            this.mTextPaint.setAlpha(255 - 255 * Math.abs(curUnit) / this.unitDisplayMax);
            this.mOrientation.draw(canvas, this.mTextPaint, (String)this.data.get(i + this.itemIndex), space, this.wheelCenterX, this.wheelCenterTextY);
            canvas.restore();
            canvas.save();
            canvas.clipRect(this.rectCurItem);
            this.mTextPaint.setColor(this.curTextColor);
            this.mOrientation.draw(canvas, this.mTextPaint, (String)this.data.get(i + this.itemIndex), space, this.wheelCenterX, this.wheelCenterTextY);
            canvas.restore();
        }
    }

    private int computeSpace(int degree) {
        int space;
        if (this.SPACE.containsKey(degree)) {
            space = this.SPACE.get(degree);
        } else {
            space = (int)(Math.sin(Math.toRadians(degree)) * (double)this.radius);
            this.SPACE.put(degree, space);
        }
        return space;
    }

    private int computeDepth(int degree) {
        int depth;
        if (this.DEPTH.containsKey(degree)) {
            depth = this.DEPTH.get(degree);
        } else {
            depth = (int)((double)this.radius - Math.cos(Math.toRadians(degree)) * (double)this.radius);
            this.DEPTH.put(degree, depth);
        }
        return depth;
    }

    @Override
    protected void onTouchMove(MotionEvent event) {
        this.degreeUnitDelta = this.mOrientation.computeDegreeSingleDelta(this.diSingleMoveX, this.diSingleMoveY, this.radius);
        int curDis = this.mOrientation.obtainCurrentDis(this.diSingleMoveX, this.diSingleMoveY);
        if (Math.abs(curDis) >= this.radius) {
            this.degreeIndex = curDis >= 0 ? ++this.degreeIndex : --this.degreeIndex;
            this.diSingleMoveX = 0;
            this.diSingleMoveY = 0;
            this.degreeUnitDelta = 0;
        }
        this.degreeSingleDelta = this.degreeIndex * 80 + this.degreeUnitDelta;
        super.onTouchMove(event);
    }

    @Override
    protected void onTouchUp(MotionEvent event) {
        this.unitDeltaTotal += this.degreeSingleDelta;
        this.degreeSingleDelta = 0;
        this.degreeUnitDelta = 0;
        this.degreeIndex = 0;
        super.onTouchUp(event);
    }

    @Override
    public void clearCache() {
        this.SPACE.clear();
        this.DEPTH.clear();
        this.mOrientation.clearCache();
    }
}

