/*
 * Decompiled with CFR 0.152.
 */
package com.aigestudio.wheelpicker.widget.curved;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.aigestudio.wheelpicker.R;
import com.aigestudio.wheelpicker.core.AbstractWheelDecor;
import com.aigestudio.wheelpicker.core.AbstractWheelPicker;
import com.aigestudio.wheelpicker.core.IWheelPicker;
import com.aigestudio.wheelpicker.view.WheelCrossPicker;
import com.aigestudio.wheelpicker.widget.curved.WheelDayPicker;
import com.aigestudio.wheelpicker.widget.curved.WheelMonthPicker;
import com.aigestudio.wheelpicker.widget.curved.WheelYearPicker;
import java.util.List;

public class WheelDatePicker
extends LinearLayout
implements IWheelPicker {
    protected WheelYearPicker pickerYear;
    protected WheelMonthPicker pickerMonth;
    protected WheelDayPicker pickerDay;
    protected AbstractWheelPicker.OnWheelChangeListener listener;
    protected String year;
    protected String month;
    protected String day;
    protected int labelColor = -16777216;
    protected int stateYear;
    protected int stateMonth;
    protected int stateDay;
    protected float labelTextSize;

    public WheelDatePicker(Context context) {
        super(context);
        this.init();
    }

    public WheelDatePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setGravity(17);
        this.setOrientation(0);
        int padding = this.getResources().getDimensionPixelSize(R.dimen.WheelPadding);
        int padding2x = padding * 2;
        this.labelTextSize = padding;
        LinearLayout.LayoutParams llParams = new LinearLayout.LayoutParams(-2, -2);
        this.pickerYear = new WheelYearPicker(this.getContext());
        this.pickerMonth = new WheelMonthPicker(this.getContext());
        this.pickerDay = new WheelDayPicker(this.getContext());
        this.pickerYear.setPadding(0, padding, padding2x, padding);
        this.pickerMonth.setPadding(0, padding, padding2x, padding);
        this.pickerDay.setPadding(0, padding, padding2x, padding);
        this.addLabel(this.pickerYear, "\u5e74");
        this.addLabel(this.pickerMonth, "\u6708");
        this.addLabel(this.pickerDay, "\u65e5");
        this.addView(this.pickerYear, (ViewGroup.LayoutParams)llParams);
        this.addView(this.pickerMonth, (ViewGroup.LayoutParams)llParams);
        this.addView(this.pickerDay, (ViewGroup.LayoutParams)llParams);
        this.initListener(this.pickerYear, 0);
        this.initListener(this.pickerMonth, 1);
        this.initListener(this.pickerDay, 2);
    }

    private void addLabel(WheelCrossPicker picker, final String label) {
        picker.setWheelDecor(true, new AbstractWheelDecor(){

            @Override
            public void drawDecor(Canvas canvas, Rect rectLast, Rect rectNext, Paint paint) {
                paint.setColor(WheelDatePicker.this.labelColor);
                paint.setTextAlign(Paint.Align.CENTER);
                paint.setTextSize(WheelDatePicker.this.labelTextSize * 1.5f);
                canvas.drawText(label, (float)rectNext.centerX(), (float)rectNext.centerY() - (paint.ascent() + paint.descent()) / 2.0f, paint);
            }
        });
    }

    private void initListener(WheelCrossPicker picker, final int type) {
        picker.setOnWheelChangeListener(new AbstractWheelPicker.OnWheelChangeListener(){

            @Override
            public void onWheelScrolling(float deltaX, float deltaY) {
                if (null != WheelDatePicker.this.listener) {
                    WheelDatePicker.this.listener.onWheelScrolling(deltaX, deltaY);
                }
            }

            @Override
            public void onWheelSelected(int index, String data) {
                if (type == 0) {
                    WheelDatePicker.this.year = data;
                }
                if (type == 1) {
                    WheelDatePicker.this.month = data;
                }
                if (type == 2) {
                    WheelDatePicker.this.day = data;
                }
                if (WheelDatePicker.this.isValidDate()) {
                    if (type == 0 || type == 1) {
                        WheelDatePicker.this.pickerDay.setCurrentYearAndMonth(Integer.valueOf(WheelDatePicker.this.year), Integer.valueOf(WheelDatePicker.this.month));
                    }
                    if (null != WheelDatePicker.this.listener) {
                        WheelDatePicker.this.listener.onWheelSelected(-1, WheelDatePicker.this.year + "-" + WheelDatePicker.this.month + "-" + WheelDatePicker.this.day);
                    }
                }
            }

            @Override
            public void onWheelScrollStateChanged(int state) {
                if (type == 0) {
                    WheelDatePicker.this.stateYear = state;
                }
                if (type == 1) {
                    WheelDatePicker.this.stateMonth = state;
                }
                if (type == 2) {
                    WheelDatePicker.this.stateDay = state;
                }
                if (null != WheelDatePicker.this.listener) {
                    WheelDatePicker.this.checkState(WheelDatePicker.this.listener);
                }
            }
        });
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
        this.invalidate();
    }

    public void setLabelTextSize(float labelTextSize) {
        this.labelTextSize = labelTextSize;
        this.invalidate();
    }

    @Override
    public void setData(List<String> data) {
        throw new RuntimeException("Set data will not allow here!");
    }

    public void setCurrentDate(int year, int month, int day) {
        this.pickerYear.setCurrentYear(year);
        this.pickerMonth.setCurrentMonth(month);
        this.pickerDay.setCurrentYearAndMonth(year, month);
        this.pickerDay.setCurrentDay(day);
    }

    @Override
    public void setOnWheelChangeListener(AbstractWheelPicker.OnWheelChangeListener listener) {
        this.listener = listener;
    }

    private void checkState(AbstractWheelPicker.OnWheelChangeListener listener) {
        if (this.stateYear == 0 && this.stateMonth == 0 && this.stateDay == 0) {
            listener.onWheelScrollStateChanged(0);
        }
        if (this.stateYear == 2 || this.stateMonth == 2 || this.stateDay == 2) {
            listener.onWheelScrollStateChanged(2);
        }
        if (this.stateYear + this.stateMonth + this.stateDay == 1) {
            listener.onWheelScrollStateChanged(1);
        }
    }

    private boolean isValidDate() {
        return !TextUtils.isEmpty((CharSequence)this.year) && !TextUtils.isEmpty((CharSequence)this.month) && !TextUtils.isEmpty((CharSequence)this.day);
    }

    @Override
    public void setItemIndex(int index) {
        this.pickerYear.setItemIndex(index);
        this.pickerMonth.setItemIndex(index);
        this.pickerDay.setItemIndex(index);
    }

    @Override
    public void setItemSpace(int space) {
        this.pickerYear.setItemSpace(space);
        this.pickerMonth.setItemSpace(space);
        this.pickerDay.setItemSpace(space);
    }

    @Override
    public void setItemCount(int count) {
        this.pickerYear.setItemCount(count);
        this.pickerMonth.setItemCount(count);
        this.pickerDay.setItemCount(count);
    }

    @Override
    public void setTextColor(int color) {
        this.pickerYear.setTextColor(color);
        this.pickerMonth.setTextColor(color);
        this.pickerDay.setTextColor(color);
    }

    @Override
    public void setTextSize(int size) {
        this.pickerYear.setTextSize(size);
        this.pickerMonth.setTextSize(size);
        this.pickerDay.setTextSize(size);
    }

    @Override
    public void clearCache() {
        this.pickerYear.clearCache();
        this.pickerMonth.clearCache();
        this.pickerDay.clearCache();
    }

    @Override
    public void setCurrentTextColor(int color) {
        this.pickerYear.setCurrentTextColor(color);
        this.pickerMonth.setCurrentTextColor(color);
        this.pickerDay.setCurrentTextColor(color);
    }

    @Override
    public void setWheelDecor(boolean ignorePadding, AbstractWheelDecor decor) {
        this.pickerYear.setWheelDecor(ignorePadding, decor);
        this.pickerMonth.setWheelDecor(ignorePadding, decor);
        this.pickerDay.setWheelDecor(ignorePadding, decor);
    }
}

